package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.row.StructureRow;
import org.jetbrains.annotations.NotNull;

import java.util.*;

public abstract class ItemTypeAttributeLoader<A> extends AbstractForestIndependentAttributeLoader<A> {
  protected final Set<String> myItemTypes;

  public ItemTypeAttributeLoader(AttributeSpec<A> spec, String... itemTypes) {
    super(spec);
    if (itemTypes == null || itemTypes.length == 0) {
      throw new IllegalArgumentException("empty or null item types");
    }
    myItemTypes = Collections.unmodifiableSet(new HashSet<>(Arrays.asList(itemTypes)));
  }

  public final boolean isEveryItemTypeSupported() {
    return false;
  }

  public final boolean isItemTypeSupported(String itemType) {
    return myItemTypes.contains(itemType);
  }

  @NotNull
  @Override
  public AttributeValue<A> loadValue(@NotNull StructureRow row, @NotNull Context context) {
    if (myItemTypes.contains(row.getItemId().getItemType())) {
      return getItemValue(row, context);
    }
    return AttributeValue.undefined();
  }
  
  protected abstract AttributeValue<A> getItemValue(@NotNull StructureRow item, @NotNull Context context);
}
