package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractForestIndependentAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.row.StructureRow;

public class ConstantValueLoader<T> extends AbstractForestIndependentAttributeLoader<T> {
  private final AttributeValue<T> myValue;

  public ConstantValueLoader(AttributeSpec<T> spec, T value) {
    super(spec);
    myValue = AttributeValue.of(value);
  }

  @Override
  public AttributeValue<T> loadValue(StructureRow row, Context context) {
    return myValue;
  }
}
