package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.AbstractPropagateLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeValue;
import com.almworks.jira.structure.api.row.StructureRow;

import java.util.*;

public class InheritedValueLoader<T> extends AbstractPropagateLoader<T> {
  private final AttributeSpec<T> myValueSpec;

  public InheritedValueLoader(AttributeSpec<T> spec, AttributeSpec<T> valueSpec) {
    super(spec);
    myValueSpec = valueSpec;
  }

  public Set<? extends AttributeSpec<?>> getAttributeDependencies() {
    return Collections.singleton(myValueSpec);
  }

  @Override
  public List<AttributeValue<T>> loadChildrenValues(AttributeValue<T> rowValue, List<StructureRow> children, 
    PropagateContext<T> context)
  {
    if (rowValue == null) rowValue = AttributeValue.undefined();
    List<AttributeValue<T>> result = new ArrayList<>(children.size());
    for (StructureRow child : children) {
      AttributeValue<T> childValue = context.getChildAttributeValue(child, myValueSpec);
      if (childValue == null || !childValue.isDefined()) {
        childValue = rowValue;
      }
      result.add(childValue);
    }
    return result;
  }
}
