package com.almworks.jira.structure.api.attribute.loader.basic;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.*;
import com.almworks.jira.structure.api.util.La;

/**
 * @author che
 */
public class LaAttributeLoader<T, R> extends ItemClassAttributeLoader<T, R> {
  private final La<? super T, ? extends R> myLa;
  private final AttributeCachingStrategy myCachingStrategy;

  public LaAttributeLoader(AttributeSpec<R> spec, Class<T> itemClass, La<? super T, ? extends R> la, String... itemTypes) {
    this(spec, AttributeCachingStrategy.guessCachingStrategy(spec), itemClass, la, itemTypes);
  }

  public LaAttributeLoader(AttributeSpec<R> spec, AttributeCachingStrategy cachingStrategy, Class<T> itemClass, La<? super T, ? extends R> la, String... itemTypes) {
    super(spec, itemClass, itemTypes);
    myCachingStrategy = cachingStrategy;
    myLa = la;
  }

  protected final AttributeValue<R> getValue(T item, Context context) {
    return AttributeValue.of(myLa.la(item));
  }

  @Override
  public AttributeCachingStrategy getCachingStrategy() {
    return myCachingStrategy;
  }
}
