package com.almworks.jira.structure.api.attribute.loader.reduce;

import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeLoaderSecurity;
import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.loader.*;
import com.almworks.jira.structure.api.cache.access.ForestAccessCache;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import org.jetbrains.annotations.NotNull;

public abstract class SecureSingleDependencyReducingAggregateLoader<T> extends SingleDependencyReducingAggregateLoader<T>
  implements BulkAttributeLoader
{
  private final ForestAccessCache myForestAccessCache;

  protected SecureSingleDependencyReducingAggregateLoader(AttributeSpec<T> spec, AttributeSpec<T> dependency, ForestAccessCache forestAccessCache) {
    super(spec, dependency);
    myForestAccessCache = forestAccessCache;
  }

  @NotNull
  @Override
  protected AttributeValue<T> getSelfValue(AttributeLoader.AggregateContext<T> context) {
    if (AttributeLoaderSecurity.isRowInvisible(context)) {
      return AttributeValue.undefined();
    }
    return super.getSelfValue(context);
  }

  @Override
  public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
    AttributeLoaderSecurity.collectInvisibleRows(rowIds, context, myForestAccessCache);
  }

  @Override
  public AttributeCachingStrategy getCachingStrategy() {
    return AttributeCachingStrategy.MUST_NOT;
  }
}
