package com.almworks.jira.structure.api.backup;

import com.almworks.integers.*;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemIdentitySet;

import java.util.List;
import java.util.Map;

public interface ErrorsContainer {
  /**
   * @return map of the issues that were not found in JIRA. Key is the issue ID, and value is a
   * message with some other details of the issue
   */
  LongObjMap<String> getInvalidIssueMessages();

  /**
   * @return map of the items that were not resolved. Key is the item ID, and value is a
   * message with some other details of the item
   */
  Map<ItemIdentity, String> getInvalidItemMessages();

  /**
   * @return map of structures that contain items that were not resolved. Key is the structure ID, and value is a
   * list of item IDs that were not resolved.
   */
  LongObjMap<ItemIdentitySet> getInvalidStructureItems();

  /**
   * @return map of structures whose change histories contain items that were not resolved. Key is the structure ID,
   * and value is a list of item IDs that were not resolved.
   */
  LongObjMap<ItemIdentitySet> getInvalidHistoryItems();

  LongObjMap<String> getInvalidSynchronizerMessages();

  LongObjMap<? extends LongList> getInvalidStructureSynchronizers();

  LongObjMap<List<String>> getStructureOtherProblems();

  List<String> getOtherProblems();

  LongSortedSet getInvalidStructures();
}
