package com.almworks.jira.structure.api.effect;

import com.almworks.jira.structure.api.forest.action.AppliedEffect;
import com.almworks.jira.structure.api.forest.action.AppliedEffectBatch;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;

import java.util.List;

@Internal
public class AppliedEffectBatchImpl implements AppliedEffectBatch {
  private final long myBatchId;

  @NotNull
  private final List<AppliedEffect> myEffects;

  public AppliedEffectBatchImpl(long batchId, @NotNull List<AppliedEffect> effects) {
    myBatchId = batchId;
    myEffects = effects;
  }

  @Override
  public long getBatchId() {
    return myBatchId;
  }

  @Override
  @NotNull
  public List<AppliedEffect> getEffects() {
    return myEffects;
  }
}
