package com.almworks.jira.structure.api.export;

import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeContextKeys;
import com.atlassian.annotations.ExperimentalApi;

/**
 * <p>This class contains keys for the {@link AttributeContext#getObject(Object)} method that can be used to retrieve
 * various objects needed to perform advanced tasks. For example, you can retrieve Apache POI model instanced to
 * do low-level manipulations in your column's Excel export renderer.</p>
 *
 * <p>The values are provided by Structure, and you cannot overwrite them, as the keys are read-only.</p>
 *
 * @see AttributeContext
 * @see ExportRequestContext
 * @see ExportRenderContext
 */
@ExperimentalApi
public final class ExportContextKeys extends AttributeContextKeys {
  /**
   * Keys for all export requests.
   */
  public enum Export {
    /**
     * The complete view specification for the current export request.
     * Value type is {@link com.almworks.jira.structure.api.view.ViewSpecification}. Read-only.
     */
    VIEW_SPECIFICATION
  }

  /**
   * Keys for Excel export requests.
   */
  public enum Excel {
    /**
     * The current Apache POI Workbook instance.
     * Value type is {@code org.apache.poi.hssf.usermodel.HSSFWorkbook}. Read-only.
     */
    POI_WORKBOOK,

    /**
     * The current Apache POI CreationHelper instance.
     * Value implements {@code org.apache.poi.ss.usermodel.CreationHelper}. Read-only.
     */
    POI_HELPER,

    /**
     * The current Apache POI Sheet instance.
     * Value implements {@code org.apache.poi.ss.usermodel.Sheet}. Read-only.
     */
    POI_SHEET,

    /**
     * The current Apache POI row index.
     * Value type is {@code java.lang.Integer}. Read-only.
     */
    POI_ROWNUM,

    /**
     * The current Apache POI Row instance.
     * Value implements {@code org.apache.poi.ss.usermodel.Row}. Read-only.
     */
    POI_ROW,

    /**
     * The current Apache POI column index.
     * Value type is {@code java.lang.Integer}. Read-only.
     */
    POI_COLUMN,

    /**
     * The current Apache POI Cell instance.
     * Value implements {@code org.apache.poi.ss.usermodel.Cell}. Read-only.
     */
    POI_CELL
  }
}
