package com.almworks.jira.structure.api.export;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.view.ViewSpecification;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * An {@code ExportRow} represents a particular item in an exported {@link Forest}.
 */
@PublicApi
public interface ExportRow {
  /**
   * <p>Returns the current {@link StructureRow} instance.</p>
   *
   * @return The current row.
   */
  @NotNull
  StructureRow getRow();

  long getRowId();

  /**
   * @return The depth of the current row in the exported
   * {@link Forest Forest}.
   */
  int getDepth();

  /**
   * @return {@code true} if the current row is expanded in the exported
   * {@link Forest Forest}.
   */
  boolean isExpanded();

  /**
   * @return {@code true} if the current row has no sub-rows in the exported
   * {@link Forest Forest}.
   */
  boolean isLeaf();

  /**
   * Gets a value of an attribute for this row.
   *
   * The attribute must have previously been requested by calling
   * {@link ExportRequestContext#requireAttribute(AttributeSpec)}
   * from {@link ExportRenderer#prepare(ExportRequestContext)} or
   * {@link ExportRendererProvider#getColumnRenderer(ExportFormat, ViewSpecification.Column, ExportRequestContext)}.
   *
   * @param attribute attribute specification
   * @param <T> attribute format type
   * @return the value or null
   */
  @Nullable
  <T> T get(AttributeSpec<T> attribute);
  
  /**
   * Gets a value of an attribute for this row. This method lets you specify whether you need a value from
   * the forest being exported or from the forest with Filter transformation removed.
   *
   * The attribute must have previously been requested by calling
   * {@link ExportRequestContext#requireAttribute(AttributeSpec, boolean)}
   * from {@link ExportRenderer#prepare(ExportRequestContext)} or
   * {@link ExportRendererProvider#getColumnRenderer(ExportFormat, ViewSpecification.Column, ExportRequestContext)}
   * with exactly the same value of {@code afterFiltering}.
   *
   * @param <T> attribute format type
   * @param attribute attribute specification
   * @param afterFiltering If true, then values are taken for the forest being exported; if false, the values are
   * taken for the same forest, but without filtering transformations.
   * @return the value or null
   *
   * @deprecated Since Structure 5.3 you don't need to track the {@code afterFiltering} flag,
   * please use {@link #get(AttributeSpec)} instead.
   */
  @Deprecated
  @Nullable
  <T> T get(AttributeSpec<T> attribute, boolean afterFiltering);
}
