package com.almworks.jira.structure.api.extension;

import com.almworks.jira.structure.api.extension.license.AppSupportInfo;
import org.jetbrains.annotations.Nullable;

import java.util.Map;

public interface StructureCoreExtension {
  /**
   * @return a map of values that is transferred to Structure Widget with the general configuration
   */
  @Nullable
  Map<String, Object> getConfigurationForWidget();

  /**
   * @return an object that is passed along with the current request for update or polling request
   */
  @Nullable
  Object getRestResponseData(@Nullable Object requestData);

  /**
   * @return an object that has license data and other app support info
   */
  @Nullable
  AppSupportInfo getAppSupportInfo();
}
