package com.almworks.jira.structure.api.forest.item;

import com.almworks.integers.IntArray;
import com.almworks.integers.LongArray;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.raw.ArrayForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemResolver;
import com.almworks.jira.structure.api.row.SimpleRow;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.row.MissingRowException;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;

public class ItemForestBuffer implements ItemForest {
  private final ItemResolver myItemResolver;

  private final List<ItemIdentity> myItems = new ArrayList<>();
  private final LongArray myRows = new LongArray();
  private final IntArray myDepths = new IntArray();
  private final ArrayForest myForest = new ArrayForest(myRows, myDepths, true);

  public ItemForestBuffer(ItemResolver itemResolver) {
    myItemResolver = itemResolver;
  }

  @NotNull
  @Override
  public Forest getForest() {
    return myForest;
  }

  @NotNull
  @Override
  public StructureRow getRow(long rowId) throws MissingRowException {
    int idx = (int)-rowId - 1;
    if (idx < 0 || idx >= myItems.size()) throw new MissingRowException(rowId);
    return new SimpleRow(rowId, myItems.get(idx), 0, myItemResolver);
  }
  
  public void clear() {
    myItems.clear();
    myRows.clear();
    myDepths.clear();
  }

  public long add(ItemIdentity item) {
    return add(item, 0);
  }

  public long add(ItemIdentity item, int depth) {
    int idx = myItems.size();
    assert (idx == 0 ? depth == 0 : myDepths.get(idx - 1) - depth >= -1) :
      idx + " " + depth + " " + myDepths + " " + item;
    long fakeRowId = -idx - 1;
    myItems.add(item);
    myRows.add(fakeRowId);
    myDepths.add(depth);
    return fakeRowId;
  }

  public ItemIdentity getItemId(int idx) {
    return myItems.get(idx);
  }
}
