package com.almworks.jira.structure.api.generator.util;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.attribute.*;
import com.almworks.jira.structure.api.forest.ForestSpec;
import com.almworks.jira.structure.api.generator.StructureGenerator;

import java.util.Collection;
import java.util.Collections;

public class GenerationUtil {
  // todo make a method in PregenerationContext instead?
  public static VersionedRowValues getValuesFromSubjectForest(StructureGenerator.GenerationContext context,
    AttributeSpec<?> spec, LongList rows, StructureAttributeService attributeService)
  {
    return getValuesFromSubjectForest(context, Collections.singletonList(spec), rows, attributeService);
  }

  public static VersionedRowValues getValuesFromSubjectForest(StructureGenerator.GenerationContext context,
    Collection<? extends AttributeSpec<?>> specs, LongList rows, StructureAttributeService attributeService)
  {
    VersionedRowValues values;
    ForestSpec transformedSpec = context.getForestSpecBeingTransformed();
    if (transformedSpec != null) {
      // view transformation - can reuse possibly cached values for the forest being transformed
      values = attributeService.getAttributeValues(transformedSpec, rows, specs);
    } else {
      // in-structure sorting or grouping, cannot reuse
      values = attributeService.getAttributeValues(context.previewForest(), rows, specs, context.getForestSpec());
    }
    return values;
  }
  
  private GenerationUtil() {}
}
