package com.almworks.jira.structure.api.rest;

import com.almworks.jira.structure.api.attribute.AttributeSpec;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Map;

@XmlRootElement
public final class RestAttributeSpec {
  /**
   * Universal attribute ID
   */
  @XmlElement
  public String id;

  /**
   * (Optional) Arbitrary parameters, interpreted by the attribute provider (any JSON)
   */
  @XmlElement
  public Map params;

  /**
   * Format - must be one of {@link com.almworks.jira.structure.api.attribute.ValueFormat} IDs
   * recognizable by the REST resource. (Custom value formats are not supported.)
   */
  @XmlElement
  public String format;

  //    /**
//     * (Optional) Alternative forest spec for calculating this attribute.
//     * The application must be somehow able to map row IDs into this spec.
//     * This implies that the spec the values are requested for is derived from this one.
//     */
//    @XmlElement
//    public RestForestSpec forestSpec;
//  @XmlElement
//  public boolean beforeTransform;

  public static RestAttributeSpec fromModel(AttributeSpec<?> spec) {
    RestAttributeSpec ras = new RestAttributeSpec();
    ras.id = spec.getId();
    ras.format = spec.getFormat().getFormatId();
    ras.params = spec.getParamsMap();
    if (ras.params.isEmpty()) ras.params = null;
    return ras;
  }

  @Override
  public String toString() {
    return "(" + id + "," + format + "," + params + ")";
  }
}
