package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class DummyRow implements StructureRow {
  private final long myRowId;

  @NotNull
  private final ItemIdentity myItemId;

  private final long mySemantics;

  @Nullable
  private final Object myItem;

  public DummyRow(long rowId, @NotNull ItemIdentity itemId, long semantics, @Nullable Object item) {
    myRowId = rowId;
    myItemId = itemId;
    mySemantics = semantics;
    myItem = item;
  }

  @Override
  public long getRowId() {
    return myRowId;
  }

  @NotNull
  @Override
  public ItemIdentity getItemId() {
    return myItemId;
  }

  @Override
  public long getSemantics() {
    return mySemantics;
  }

  @Nullable
  @Override
  public <I> I getItem(@NotNull Class<I> itemClass) {
    return itemClass.isInstance(myItem) ? itemClass.cast(myItem) : null;
  }
}
