package com.almworks.jira.structure.api.row;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemResolver;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public final class SimpleRow implements StructureRow {
  private final long myRowId;
  private final ItemIdentity myItemId;
  private final long mySemantics;

  private final ItemResolver myResolver;

  private volatile boolean myItemLoaded;
  private Object myItem;

  public SimpleRow(long rowId, ItemIdentity itemId, long semantics, ItemResolver resolver) {
    myRowId = rowId;
    myItemId = itemId;
    mySemantics = semantics;
    myResolver = resolver;
  }

  @Override
  public long getRowId() {
    return myRowId;
  }

  @Nullable
  @Override
  public <I> I getItem(@NotNull Class<I> itemClass) {
    if (!myItemLoaded) {
      synchronized (this) {
        if (!myItemLoaded) {
          try {
            myItem = myResolver.resolveItem(getItemId(), Object.class);
          } finally {
            myItemLoaded = true;
          }
        }
      }
    }
    return itemClass.isInstance(myItem) ? itemClass.cast(myItem) : null;
  }

  @NotNull
  @Override
  public ItemIdentity getItemId() {
    return myItemId;
  }

  @Override
  public long getSemantics() {
    return mySemantics;
  }

  @Override
  public String toString() {
    return "SimpleRow[" +  myRowId + ":" + myItemId + ":" + mySemantics + "]";
  }
}
