package com.almworks.jira.structure.api.view;

import com.atlassian.annotations.PublicApi;

/**
 * {@code StructureViewMenuItem} is a small helper class that is basically a pair of
 * {@link StructureView} and a {@code boolean}. The latter tells whether the view
 * is "preferred", that is, it should be used as the default view.
 *
 * @author Igor Sereda
 */
@PublicApi
public class StructureViewMenuItem {
  private final StructureView myView;
  private final boolean myPreferred;

  public StructureViewMenuItem(StructureView view, boolean preferred) {
    myView = view;
    myPreferred = preferred;
  }

  public boolean isPreferred() {
    return myPreferred;
  }

  public StructureView getView() {
    return myView;
  }

  public String toString() {
    return "StructureViewMenuItem{" +
      "view=" + myView +
      ", preferred=" + myPreferred +
      '}';
  }
}
