package com.almworks.jira.structure.api.attribute;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;

@PublicApi
public final class CoreAttributeSpecs extends SharedAttributeSpecs {
  public static final AttributeSpec<Priority> PRIORITY = new AttributeSpec<>(SharedAttributeSpecs.Id.PRIORITY, Format.PRIORITY);
  public static final AttributeSpec<Project> PROJECT = new AttributeSpec<>(SharedAttributeSpecs.Id.PROJECT, Format.PROJECT);
  public static final AttributeSpec<ApplicationUser> ASSIGNEE = new AttributeSpec<>(SharedAttributeSpecs.Id.ASSIGNEE, Format.USER);
  public static final AttributeSpec<ApplicationUser> REPORTER = new AttributeSpec<>(SharedAttributeSpecs.Id.REPORTER, Format.USER);
  public static final AttributeSpec<ApplicationUser> CREATOR = new AttributeSpec<>(Id.CREATOR, Format.USER);
  public static final AttributeSpec<IssueType> ISSUETYPE = new AttributeSpec<>(SharedAttributeSpecs.Id.TYPE, Format.ISSUETYPE);
  public static final AttributeSpec<Status> STATUS = new AttributeSpec<>(SharedAttributeSpecs.Id.STATUS, Format.STATUS);
  public static final AttributeSpec<Object> ITEM = new AttributeSpec<>(Id.ITEM, ValueFormat.ANY);
  public static final AttributeSpec<Long> DUEDATE = new AttributeSpec<>(Id.DUEDATE, ValueFormat.TIME);
  public static final AttributeSpec<Long> CREATED = new AttributeSpec<>(Id.CREATED, ValueFormat.TIME);
  public static final AttributeSpec<Long> UPDATED = new AttributeSpec<>(Id.UPDATED, ValueFormat.TIME);

  private CoreAttributeSpecs() {}

  public static final class Format {
    public static final ValueFormat<Priority> PRIORITY = new ValueFormat<>(SharedAttributeSpecs.Id.PRIORITY, Priority.class);
    public static final ValueFormat<Project> PROJECT = new ValueFormat<>(SharedAttributeSpecs.Id.PROJECT, Project.class);
    public static final ValueFormat<ApplicationUser> USER = new ValueFormat<>(SharedAttributeSpecs.Id.USER, ApplicationUser.class);
    public static final ValueFormat<IssueType> ISSUETYPE = new ValueFormat<>(SharedAttributeSpecs.Id.ISSUETYPE, IssueType.class);
    public static final ValueFormat<Status> STATUS = new ValueFormat<>(SharedAttributeSpecs.Id.STATUS, Status.class);

    private Format() {}
  }

  public static final class Id extends SharedAttributeSpecs.Id {
    public static final String ITEM = "item";
    public static final String CREATOR = "creator";
    public static final String DUEDATE = "duedate";
    public static final String CREATED = "created";
    public static final String UPDATED = "updated";
    public static final String COMPONENTS = "components";
    public static final String AFFECTS_VERSIONS = "versions";
    public static final String FIX_VERSIONS = "fixVersions";
    public static final String LABELS = "labels";

    private Id() {}
  }
}
