package com.almworks.jira.structure.api.attribute;

/**
 * This class contains row values and the update checker that can be used to see if these row values may have been outdated.
 *
 * @see StructureAttributeService#getAttributeValuesWithUpdateChecker
 * @see RowValues
 * @see AttributeUpdateChecker
 */
public class RowValuesWithUpdateChecker {
  private final RowValues myRowValues;
  private final AttributeUpdateChecker myUpdateChecker;

  /**
   * Creates an instance of the class.
   *
   * @param rowValues row values
   * @param updateChecker update checker
   */
  public RowValuesWithUpdateChecker(RowValues rowValues, AttributeUpdateChecker updateChecker) {
    myRowValues = rowValues;
    myUpdateChecker = updateChecker;
  }

  /**
   * Returns the row values.
   *
   * @return row values
   */
  public RowValues getRowValues() {
    return myRowValues;
  }

  /**
   * Returns the update checker.
   *
   * @return update checker
   */
  public AttributeUpdateChecker getUpdateChecker() {
    return myUpdateChecker;
  }
}
