package com.almworks.jira.structure.api.backup;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;

import java.util.Map;

/**
 * Stores mappings from entity ID in the backup file to restored entity ID.
 */
@Internal
public interface MigrationMapping {
  /**
   * Returns structure IDs mapping.
   * Also defines the set of structures to migrate.
   *
   * @return keys of this map are IDs of structures to migrate as they occur in the backup file;
   *         values - corresponding structure IDs in the system.
   */
  @NotNull
  Map<Long, Long> getStructureIds();

  /**
   * Returns non-issue item IDs (folders, memos, generators, etc) mapping.
   * May contain {@code ItemIdentity.ITEM_ZERO} value for unresolved items.
   *
   * @return keys of this map are item IDs to migrate as they occur in the backup file;
   *         values - corresponding item IDs in the system.
   */
  @NotNull
  Map<ItemIdentity, ItemIdentity> getItemIds();
}
