package com.almworks.jira.structure.api.extension;

import com.almworks.integers.LongSet;
import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.*;

/**
 * With this interface a Structure extension may inform that the plugin adds new features to particular structures.<br>
 * Register you component in the atlassian-plugin.xml file:
 * <pre>
 * &lt;structure-integration-details-provider key="KEY" class="YOUR_IMPLEMENTATION_CLASS"/&gt;
 * </pre>
 */
@Internal
public interface StructureIntegrationDetails {
  /**
   * @return URL of the plugin Logo
   */
  String getProductIconUrl();

  /**
   * @return selected structures this plugin integrates with (add new features).<br>
   * {@code null} - if the plugin does not support this operation, e.g. no efficient implementation is possible.
   */
  @Nullable
  LongSet selectIntegratedStructures(@NotNull LongSet structureIds);
}
