package com.almworks.jira.structure.api.generator;

import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import javax.annotation.concurrent.Immutable;
import java.util.Map;

@PublicApi
@Immutable
public final class GeneratorSpec {
  @NotNull
  private final String myModuleKey;

  @NotNull
  private final Map<String, Object> myParameters;

  @Nullable
  private final Long myOwningStructure;

  public GeneratorSpec(@NotNull String moduleKey, @Nullable Map<String, Object> parameters, @Nullable Long owningStructure) {
    myModuleKey = StructureUtil.nonBlank(moduleKey);
    myParameters = JsonMapUtil.copyParameters(parameters, false, true, false);
    myOwningStructure = owningStructure;
  }

  @NotNull
  public String getModuleKey() {
    return myModuleKey;
  }

  @NotNull
  public Map<String, Object> getParameters() {
    return myParameters;
  }

  @Nullable
  public Long getOwningStructure() {
    return myOwningStructure;
  }
}
