package com.almworks.jira.structure.api.memo;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.Nullable;

import java.time.LocalDate;

@PublicApi
public interface Memo {
  @Nullable
  String getSummary();
  @Nullable
  String getDescription();
  @Nullable
  ApplicationUser getAssignee();
  @Nullable
  LocalDate getDueDate();
  @Nullable
  Long getOriginalEstimate();
  @Nullable
  Long getRemainingEstimate();
  @Nullable
  Long getTimeSpent();
}
