package com.almworks.jira.structure.api.memo;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

@PublicApi
public interface MemoManager {
  @Nullable
  Memo getMemo(long memoId);

  @NotNull
  List<? extends Memo> getMemos(@NotNull Collection<Long> memoIds);

  @NotNull
  MemoUpdateBuilder getUpdateBuilder(long memoId);
}
