package com.almworks.jira.structure.api.planningtask;

import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;

@Internal
public interface PlanningTaskManager {
  @Nullable
  PlanningTask getPlanningTask(long planningTaskId);

  @NotNull
  List<? extends PlanningTask> getPlanningTasks(@NotNull Collection<Long> planningTaskIds);

  @NotNull
  PlanningTaskUpdateBuilder getUpdateBuilder(long planningTaskId);
}
