package com.almworks.jira.structure.api.util;

import com.almworks.integers.*;

public final class IntegersUtil {

  public static boolean isMutuallyExclusive(LongList list1, LongList list2) {
    if (list2.isEmpty() || list1.isEmpty()) return true;
    LongList hashed, iterated;
    boolean insertedIsHashed = list1.size() < list2.size();
    hashed = insertedIsHashed ? list1 : list2;
    iterated = insertedIsHashed ? list2 : list1;
    LongOpenHashSet set = LongOpenHashSet.createFrom(hashed);
    return !set.containsAny(iterated);
  }

  // todo add to integers
  public static boolean isMutuallyExclusive(LongSet set1, LongSet set2) {
    boolean set1Iterated = set1.size() < set2.size();
    LongSet iterated = set1Iterated ? set1 : set2;
    LongSet checked = set1Iterated ? set2 : set1;
    return !checked.containsAny(iterated);
  }

  private IntegersUtil() {}
}
