package com.almworks.jira.structure.api.export;

import com.almworks.jira.structure.api.attribute.AttributeSpec;
import com.almworks.jira.structure.api.attribute.RowValues;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

/**
 * <p>A subtype of {@link AttributeContext} passed to {@link ExportRenderer}.</p>
 *
 * @see AttributeContext
 * @see ExportRequestContext
 */
@PublicApi
public interface ExportRenderContext extends AttributeContext {
  // todo review if this method is needed (we have ExportRow.get()), and if it's ok to remove this interface altogether
  /**
   * <p>Returns the {@link RowValues} that contains the values of all attributes previously required by calling
   * {@link ExportRequestContext#requireAttribute(AttributeSpec)} for all rows associated with the current request.</p>
   *
   * @return The aggregation result, never {@code null}.
   *
   * @see ExportRequestContext#requireAttribute(AttributeSpec)
   */
  @NotNull
  RowValues getValues();
}
