package com.almworks.jira.structure.api.generator.util;

import com.almworks.jira.structure.api.generator.ItemChangeFilter;
import com.almworks.jira.structure.api.generator.StructureGenerator;
import com.almworks.jira.structure.api.item.ItemIdentity;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

public class SingleItemChangeFilter implements ItemChangeFilter {
  private final ItemIdentity myItemId;

  public SingleItemChangeFilter(ItemIdentity itemId) {
    if (itemId == null) {
      throw new NullPointerException();
    }
    myItemId = itemId;
  }

  @Override
  public boolean accept(@NotNull Set<ItemIdentity> itemIds, @NotNull StructureGenerator.ItemChangeFilterContext context) {
    return itemIds.contains(myItemId);
  }
}
