/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest.action;

import com.almworks.integers.LongList;
import com.almworks.integers.LongLongIterable;
import com.almworks.integers.LongLongMap;
import com.almworks.integers.wrappers.LongLongHppcOpenHashMap;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.item.ImmutableItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.forest.item.ItemForestBuilderImpl;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import com.atlassian.annotations.PublicSpi;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@PublicApi
public abstract class ForestAction {
    private ForestAction() {
    }

    public abstract void accept(Visitor var1) throws StructureException;

    @PublicSpi
    public static interface Visitor {
        public void visit(@NotNull Remove var1) throws StructureException;

        public void visit(@NotNull Move var1) throws StructureException;

        public void visit(@NotNull Add var1) throws StructureException;

        public void visit(@NotNull Copy var1) throws StructureException;
    }

    @PublicApi
    @Immutable
    public static final class Copy
    extends ForestAction {
        private final ItemForest myFragment;
        private final long myUnder;
        private final long myAfter;
        private final long myBefore;
        private final LongLongMap myOriginalRows;

        public Copy(ItemForest fragment, long under, long after, long before, LongLongMap originalRows) {
            this.myFragment = ImmutableItemForest.copy(fragment);
            this.myUnder = under;
            this.myAfter = after;
            this.myBefore = before;
            LongLongHppcOpenHashMap map = new LongLongHppcOpenHashMap(originalRows.size());
            map.putAll((LongLongIterable)originalRows);
            this.myOriginalRows = map;
        }

        public ItemForest getFragment() {
            return this.myFragment;
        }

        public long getUnder() {
            return this.myUnder;
        }

        public long getAfter() {
            return this.myAfter;
        }

        public long getBefore() {
            return this.myBefore;
        }

        public LongLongMap getOriginalRows() {
            return this.myOriginalRows;
        }

        @Override
        public void accept(Visitor visitor) throws StructureException {
            visitor.visit(this);
        }

        public String toString() {
            return "copy:" + this.myFragment.getForest() + ":" + this.myUnder + ":" + this.myAfter + ":" + this.myBefore + ":" + this.myOriginalRows;
        }
    }

    @PublicApi
    @Immutable
    public static final class Add
    extends ForestAction {
        private final ItemForest myFragment;
        private final long myUnder;
        private final long myAfter;
        private final long myBefore;

        public Add(@NotNull ItemForest fragment, long under, long after, long before) {
            this.myFragment = ImmutableItemForest.copy(fragment);
            this.myUnder = under;
            this.myAfter = after;
            this.myBefore = before;
        }

        public Add(@NotNull ItemIdentity itemId, long semantics, long under, long after, long before) {
            this(new ItemForestBuilderImpl().nextRow(itemId, semantics).build(), under, after, before);
        }

        public Add(@NotNull ItemIdentity itemId, long under, long after, long before) {
            this(itemId, 0L, under, after, before);
        }

        @NotNull
        public ItemForest getFragment() {
            return this.myFragment;
        }

        public long getUnder() {
            return this.myUnder;
        }

        public long getAfter() {
            return this.myAfter;
        }

        public long getBefore() {
            return this.myBefore;
        }

        @Override
        public void accept(Visitor visitor) throws StructureException {
            visitor.visit(this);
        }

        public String toString() {
            return "add:" + this.myFragment.getForest() + ":" + this.myUnder + ":" + this.myAfter + ":" + this.myBefore;
        }
    }

    @PublicApi
    @Immutable
    public static final class Move
    extends ForestAction {
        private final LongList myRowIds;
        private final long myUnder;
        private final long myAfter;
        private final long myBefore;

        public Move(LongList rowIds, long under, long after, long before) {
            this.myRowIds = rowIds;
            this.myUnder = under;
            this.myAfter = after;
            this.myBefore = before;
        }

        public LongList getRowIds() {
            return this.myRowIds;
        }

        public long getUnder() {
            return this.myUnder;
        }

        public long getAfter() {
            return this.myAfter;
        }

        public long getBefore() {
            return this.myBefore;
        }

        @Override
        public void accept(Visitor visitor) throws StructureException {
            visitor.visit(this);
        }

        public String toString() {
            return "move:" + this.myRowIds + ":" + this.myUnder + ":" + this.myAfter + ":" + this.myBefore;
        }
    }

    @PublicApi
    @Immutable
    public static final class Remove
    extends ForestAction {
        private final LongList myRowIds;

        public Remove(LongList rowIds) {
            this.myRowIds = rowIds;
        }

        public LongList getRowIds() {
            return this.myRowIds;
        }

        @Override
        public void accept(Visitor visitor) throws StructureException {
            visitor.visit(this);
        }

        public String toString() {
            return "remove:" + this.myRowIds;
        }
    }
}

