/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.settings;

import com.almworks.jira.structure.api.settings.AutoSwitchStrategy;
import com.almworks.jira.structure.api.settings.StructurePage;
import com.almworks.jira.structure.api.settings.UISettings;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UISettingsBean
implements UISettings {
    private final EnumMap<StructurePage, AutoSwitchStrategy> myAutoSwitchStrategyMap = new EnumMap(StructurePage.class);
    private Boolean myAutoCollapseStructurePanel;
    private Boolean myKeepStructureWhileNavigating;

    public UISettingsBean() {
    }

    public UISettingsBean(@Nullable UISettings copyFrom) {
        if (copyFrom != null) {
            for (StructurePage page : StructurePage.values()) {
                AutoSwitchStrategy strategy = copyFrom.getAutoSwitchStrategy(page);
                if (strategy == null) continue;
                this.myAutoSwitchStrategyMap.put(page, strategy);
            }
            this.myAutoCollapseStructurePanel = copyFrom.getAutoCollapseStructurePanel();
        }
    }

    @Override
    @Nullable
    public AutoSwitchStrategy getAutoSwitchStrategy(@NotNull StructurePage page) {
        return this.myAutoSwitchStrategyMap.get((Object)page);
    }

    @NotNull
    public UISettingsBean setAutoSwitchStrategy(@NotNull StructurePage page, @Nullable AutoSwitchStrategy strategy) {
        if (page == null) {
            throw new NullPointerException("page is null");
        }
        if (strategy == null) {
            this.myAutoSwitchStrategyMap.remove((Object)page);
        } else {
            this.myAutoSwitchStrategyMap.put(page, strategy);
        }
        return this;
    }

    @Override
    public Boolean getAutoCollapseStructurePanel() {
        return this.myAutoCollapseStructurePanel;
    }

    @Override
    public Boolean getKeepStructureWhileNavigating() {
        return this.myKeepStructureWhileNavigating;
    }

    public void setKeepStructureWhileNavigating(Boolean keepStructureWhileNavigating) {
        this.myKeepStructureWhileNavigating = keepStructureWhileNavigating;
    }

    public void setAutoCollapseStructurePanel(Boolean autoCollapseStructurePanel) {
        this.myAutoCollapseStructurePanel = autoCollapseStructurePanel;
    }

    @Override
    public boolean isAnythingSet() {
        return !this.myAutoSwitchStrategyMap.isEmpty() || this.myAutoCollapseStructurePanel != null || this.myKeepStructureWhileNavigating != null;
    }
}

