/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.error;

import com.almworks.jira.structure.api.darkfeature.DarkFeatures;
import com.almworks.jira.structure.api.error.StructureError;
import com.almworks.jira.structure.api.error.StructureErrors;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.RowManager;
import com.almworks.jira.structure.api.util.I18nText;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class StructureException
extends Exception {
    private static final Logger logger = LoggerFactory.getLogger(StructureException.class);
    private static final boolean ITEM_LOOKUP_ENABLED = StructureException.isItemLookupEnabled();
    private static final ThreadLocal<Boolean> ITEM_LOOKUP_IN_PROGRESS = new ThreadLocal();
    @NotNull
    private final StructureError myError;
    @NotNull
    private final String myProblemDetails;
    private final long myStructure;
    private final long myView;
    private final long myRow;
    private final ItemIdentity myItem;
    private final String myMessageKey;
    private final Object[] myMessageParameters;

    public StructureException(@Nullable StructureError error) {
        this(error, null, null, null, null, null, null, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable String message) {
        this(error, null, null, null, null, null, message, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable Long structure) {
        this(error, null, structure, null, null, null, null, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable Long structure, @Nullable Long row) {
        this(error, null, structure, null, row, null, null, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable Long structure, @Nullable Long row, @Nullable String message) {
        this(error, null, structure, null, row, null, message, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable Long structure, @Nullable Long row, @Nullable String message, @Nullable Throwable cause) {
        this(error, cause, structure, null, row, null, message, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable Long structure, @Nullable Long row, @Nullable Long view) {
        this(error, null, structure, view, row, null, null, null, new Object[0]);
    }

    public StructureException(@Nullable StructureError error, @Nullable Long structure, @Nullable Long row, @Nullable Long view, @Nullable String message) {
        this(error, null, structure, view, row, null, message, null, new Object[0]);
    }

    protected StructureException(StructureError error, @Nullable Throwable cause, @Nullable Long structure, @Nullable Long view, @Nullable Long row, @Nullable ItemIdentity item, @Nullable String message, @Nullable String messageKey, Object ... messageParameters) {
        super(StructureException.createMessage(error, structure, view, row, item, message, messageKey, messageParameters), cause);
        this.myError = error == null ? StructureErrors.GENERIC_ERROR : error;
        String details = StructureException.createDetails(message, messageKey, messageParameters);
        this.myProblemDetails = details.isEmpty() ? "error " + this.myError : details;
        this.myStructure = structure == null ? 0L : structure;
        this.myView = view == null ? 0L : view;
        this.myRow = row == null ? 0L : row;
        this.myItem = item;
        this.myMessageKey = messageKey;
        this.myMessageParameters = messageParameters;
    }

    private static String createMessage(StructureError error, Long structure, Long view, Long row, ItemIdentity itemId, @Nullable String message, @Nullable String messageKey, Object ... messageParameters) {
        String details;
        StringBuilder b = new StringBuilder();
        if (error == null) {
            error = StructureErrors.GENERIC_ERROR;
        }
        if (!(details = StructureException.createDetails(message, messageKey, messageParameters)).isEmpty()) {
            b.append(details).append(" - ");
        }
        b.append("structure ").append(error.name()).append(" (code:").append(error.getCode());
        if (structure != null && structure > 0L) {
            b.append(" structure:").append(structure);
        }
        if (view != null && view > 0L) {
            b.append(" view:").append(view);
        }
        if (row != null && row > 0L) {
            b.append(" row:").append(row);
            if (ITEM_LOOKUP_ENABLED) {
                StructureException.protectFromReentrancy(() -> StructureException.appendRowDescription(b, row));
            }
        }
        if (itemId != null) {
            b.append(" item:").append(itemId);
            if (ITEM_LOOKUP_ENABLED) {
                StructureException.protectFromReentrancy(() -> StructureException.appendItemDescription(b, itemId));
            }
        }
        b.append(')');
        return b.toString();
    }

    @NotNull
    private static String createDetails(String message, String messageKey, Object ... messageParameters) {
        if (message == null && (message = StructureException.getRootLocaleMessage(messageKey, messageParameters)) == null) {
            message = "";
        }
        return message;
    }

    private static void appendRowDescription(StringBuilder b, long rowId) {
        try {
            RowManager rowManager = JiraComponents.getOSGiComponentInstanceOfType(RowManager.class);
            if (rowManager != null) {
                StructureException.appendItemDescription(b, rowManager.getRow(rowId).getItemId());
            }
        }
        catch (Exception | LinkageError e) {
            logger.warn("Error on building structure exception", e);
        }
    }

    private static void appendItemDescription(StringBuilder b, ItemIdentity itemId) {
        try {
            String description = StructureUtil.getItemDescription(itemId);
            if (description != null) {
                b.append(" (").append(description).append(')');
            }
        }
        catch (Exception | LinkageError e) {
            logger.warn("Error on building structure exception", e);
        }
    }

    private static String getRootLocaleMessage(String messageKey, Object ... messageParameters) {
        try {
            return StructureUtil.getText(Locale.ENGLISH, null, messageKey, messageParameters);
        }
        catch (Exception | LinkageError e) {
            logger.warn("Error on building structure exception", e);
            return "";
        }
    }

    @Override
    public String toString() {
        String s = this.getClass().getName();
        String message = this.getMessage();
        return message != null ? s + ": " + message : s;
    }

    @NotNull
    public StructureError getError() {
        return this.myError;
    }

    @NotNull
    public String getProblemDetails() {
        return this.myProblemDetails;
    }

    public long getStructure() {
        return this.myStructure;
    }

    public long getView() {
        return this.myView;
    }

    public long getRow() {
        return this.myRow;
    }

    @Nullable
    public ItemIdentity getItem() {
        return this.myItem;
    }

    public boolean isLocalized() {
        return this.myMessageKey != null;
    }

    @Override
    @NotNull
    public String getLocalizedMessage() {
        return this.isLocalized() ? StructureUtil.getTextInCurrentUserLocale(this.myMessageKey, this.myMessageParameters) : this.getProblemDetails();
    }

    @NotNull
    public String getLocalizedMessage(@Nullable ApplicationUser user) {
        return this.isLocalized() ? StructureUtil.getText(null, user, this.myMessageKey, this.myMessageParameters) : this.getProblemDetails();
    }

    @NotNull
    public I18nText asI18nText() {
        return this.isLocalized() ? new I18nText(this.myMessageKey, this.myMessageParameters) : new I18nText(this.getProblemDetails(), new Object[0]);
    }

    private static boolean isItemLookupEnabled() {
        String enable = DarkFeatures.getProperty("structure.exception.enable.lookup");
        if (enable != null) {
            return Boolean.parseBoolean(enable);
        }
        String disable = DarkFeatures.getProperty("structure.exception.disable.lookup");
        if (disable != null) {
            return !Boolean.parseBoolean(disable);
        }
        return StructureUtil.isDevMode();
    }

    private static void protectFromReentrancy(Runnable code) {
        Boolean value = ITEM_LOOKUP_IN_PROGRESS.get();
        if (value != null && value.booleanValue()) {
            return;
        }
        ITEM_LOOKUP_IN_PROGRESS.set(Boolean.TRUE);
        try {
            code.run();
        }
        finally {
            ITEM_LOOKUP_IN_PROGRESS.remove();
        }
    }

    @PublicApi
    public static class Builder {
        private StructureError myError;
        private String myMessage;
        private Long myStructure;
        private Long myView;
        private Long myRow;
        private ItemIdentity myItem;
        private String myMessageKey;
        private Object[] myMessageParameters;
        private Throwable myCause;

        public Builder(StructureError error) {
            this.myError = error;
        }

        @NotNull
        public StructureException withLocalizedMessage(@Nullable String messageKey, Object ... messageParameters) {
            this.myMessage = messageKey == null ? "" : StructureException.getRootLocaleMessage(messageKey, messageParameters);
            this.myMessageKey = messageKey;
            this.myMessageParameters = messageParameters;
            return this.build();
        }

        @NotNull
        public StructureException withMessage(@Nullable String message) {
            this.myMessage = message;
            this.myMessageKey = null;
            this.myMessageParameters = null;
            return this.build();
        }

        @NotNull
        public StructureException withoutMessage() {
            this.myMessage = null;
            this.myMessageKey = null;
            this.myMessageParameters = null;
            return this.build();
        }

        @NotNull
        public Builder forStructure(@Nullable Long structure) {
            this.myStructure = structure;
            return this;
        }

        @NotNull
        public Builder forView(@Nullable Long view) {
            this.myView = view;
            return this;
        }

        @NotNull
        public Builder forRow(@Nullable Long row) {
            this.myRow = row;
            return this;
        }

        @NotNull
        public Builder forItem(@Nullable ItemIdentity item) {
            this.myItem = item;
            return this;
        }

        @NotNull
        public Builder forIssue(long issueId) {
            return this.forItem(CoreIdentities.issue(issueId));
        }

        @NotNull
        public Builder causedBy(Throwable cause) {
            this.myCause = cause;
            return this;
        }

        @NotNull
        private StructureException build() {
            return new StructureException(this.myError, this.myCause, this.myStructure, this.myView, this.myRow, this.myItem, this.myMessage, this.myMessageKey, this.myMessageParameters);
        }
    }
}

