/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.item.generic;

import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.generic.GenericItem;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.util.ErrorCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface GenericItemService {
    @NotNull
    public GenericItemResult getItem(@NotNull ItemIdentity var1);

    @NotNull
    public CreateValidationResult validateCreate(@NotNull String var1, @NotNull GenericItem var2);

    @NotNull
    public GenericItemResult create(@NotNull CreateValidationResult var1);

    @NotNull
    public UpdateValidationResult validateUpdate(@NotNull ItemIdentity var1, @NotNull GenericItem var2);

    @NotNull
    public GenericItemResult update(@NotNull UpdateValidationResult var1);

    @NotNull
    public DeleteValidationResult validateDelete(@NotNull ItemIdentity var1);

    @NotNull
    public GenericItemResult delete(@NotNull DeleteValidationResult var1);

    public static class DeleteValidationResult
    extends ExceptionSupportResult {
        private final ItemIdentity myItemId;

        public DeleteValidationResult(@NotNull ErrorCollection errors, @Nullable StructureException exception, @NotNull ItemIdentity itemId) {
            super(errors, exception);
            this.myItemId = itemId;
        }

        @NotNull
        public ItemIdentity getItemId() {
            return this.myItemId;
        }
    }

    public static class UpdateValidationResult
    extends ExceptionSupportResult {
        private final ItemIdentity myItemId;
        private final GenericItem myGenericItem;

        public UpdateValidationResult(@NotNull ErrorCollection errors, @Nullable StructureException exception, @NotNull ItemIdentity itemId, @NotNull GenericItem genericItem) {
            super(errors, exception);
            this.myItemId = itemId;
            this.myGenericItem = genericItem;
        }

        @NotNull
        public ItemIdentity getItemId() {
            return this.myItemId;
        }

        public GenericItem getGenericItem() {
            return this.myGenericItem;
        }
    }

    public static class CreateValidationResult
    extends ExceptionSupportResult {
        private final String myItemType;
        private final GenericItem myGenericItem;

        public CreateValidationResult(@NotNull ErrorCollection errors, @Nullable StructureException exception, @NotNull String itemType, @NotNull GenericItem genericItem) {
            super(errors, exception);
            this.myItemType = itemType;
            this.myGenericItem = genericItem;
        }

        @NotNull
        public String getItemType() {
            return this.myItemType;
        }

        @NotNull
        public GenericItem getGenericItem() {
            return this.myGenericItem;
        }
    }

    public static class GenericItemResult
    extends ExceptionSupportResult {
        private final ItemIdentity myItemId;
        private final GenericItem myGenericItem;

        public GenericItemResult(@NotNull ErrorCollection errors, @Nullable StructureException exception, @Nullable ItemIdentity itemId, @Nullable GenericItem genericItem) {
            super(errors, exception);
            this.myItemId = itemId;
            this.myGenericItem = genericItem;
        }

        @Nullable
        public ItemIdentity getItemId() {
            return this.myItemId;
        }

        @Nullable
        public GenericItem getGenericItem() {
            return this.myGenericItem;
        }
    }

    public static abstract class ExceptionSupportResult
    extends ServiceResultImpl {
        private final StructureException myException;

        ExceptionSupportResult(@NotNull ErrorCollection errorCollection, @Nullable StructureException exception) {
            super(errorCollection);
            this.myException = exception;
        }

        public boolean isValid() {
            return super.isValid() && this.myException == null;
        }

        @Nullable
        public StructureException getException() {
            return this.myException;
        }
    }
}

