/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.view;

import com.almworks.jira.structure.api.util.JsonMapUtil;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.almworks.jira.structure.api.view.ColumnDisplayMode;
import com.atlassian.annotations.PublicApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class ViewSpecification {
    public static final ViewSpecification EMPTY = new ViewSpecification(null, true, 1, null);
    private final List<Column> myColumns;
    private final int myColumnDisplayMode;
    private final List<String> myPins;

    private ViewSpecification(List<Column> columns, boolean reuseList, int columnDisplayMode, List<String> pins) {
        this.myColumns = columns == null ? Collections.emptyList() : Collections.unmodifiableList(reuseList ? columns : new ArrayList(columns));
        this.myColumnDisplayMode = columnDisplayMode;
        this.myPins = pins == null ? Collections.emptyList() : Collections.unmodifiableList(reuseList ? pins : new ArrayList(pins));
    }

    @NotNull
    public List<Column> getColumns() {
        return this.myColumns;
    }

    public int getColumnDisplayMode() {
        return this.myColumnDisplayMode;
    }

    @NotNull
    public List<String> getPins() {
        return this.myPins;
    }

    public String toString() {
        return "ViewSpecification{columns=" + this.myColumns + ", columnDisplayMode='" + this.myColumnDisplayMode + '\'' + ", pins='" + this.myPins + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewSpecification that = (ViewSpecification)o;
        return this.myColumns.equals(that.myColumns) && this.myColumnDisplayMode == that.myColumnDisplayMode && this.myPins.equals(that.myPins);
    }

    public int hashCode() {
        int result = this.myColumns.hashCode();
        result = 31 * result + this.myColumnDisplayMode;
        result = 31 * result + this.myPins.hashCode();
        return result;
    }

    public static class Column {
        private final String myCsid;
        private final String myKey;
        private final String myName;
        private final Map<String, Object> myParameters;

        private Column(String csid, String key, String name, Map<String, Object> parameters) {
            this.myCsid = csid == null ? "" : csid;
            this.myKey = key == null ? "" : key;
            this.myName = name;
            this.myParameters = JsonMapUtil.copyParameters(parameters, false, true, false);
        }

        @NotNull
        public String getCsid() {
            return this.myCsid;
        }

        @NotNull
        public String getKey() {
            return this.myKey;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @NotNull
        public Map<String, Object> getParameters() {
            return this.myParameters;
        }

        public String toString() {
            return "Column{csid='" + this.myCsid + '\'' + ", key='" + this.myKey + '\'' + ", name='" + this.myName + '\'' + ", parameters=" + this.myParameters + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (!this.myCsid.equals(column.myCsid)) {
                return false;
            }
            if (!this.myKey.equals(column.myKey)) {
                return false;
            }
            if (this.myName != null ? !this.myName.equals(column.myName) : column.myName != null) {
                return false;
            }
            return !(this.myParameters != null ? !this.myParameters.equals(column.myParameters) : column.myParameters != null);
        }

        public int hashCode() {
            int result = this.myCsid.hashCode();
            result = 31 * result + this.myKey.hashCode();
            result = 31 * result + (this.myName != null ? this.myName.hashCode() : 0);
            result = 31 * result + (this.myParameters != null ? this.myParameters.hashCode() : 0);
            return result;
        }

        @XmlRootElement(name="column")
        @XmlType(name="column", propOrder={"csid", "key", "name", "parameters"})
        @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
        public static class Builder
        implements Cloneable {
            private String myCsid;
            private String myKey;
            private String myName;
            private Map<String, Object> myParameters;

            public Builder() {
            }

            public Builder(@Nullable Column column) {
                if (column != null) {
                    this.myCsid = column.getCsid();
                    this.myKey = column.getKey();
                    this.myName = column.getName();
                    this.myParameters = JsonMapUtil.copyParameters(column.getParameters(), true, false, false);
                }
            }

            public Builder clone() {
                try {
                    Builder r = (Builder)super.clone();
                    r.myParameters = JsonMapUtil.copyParameters(r.myParameters, true, false, false);
                    return r;
                }
                catch (CloneNotSupportedException e) {
                    throw new AssertionError((Object)e);
                }
            }

            @XmlElement
            @Nullable
            public String getCsid() {
                return this.myCsid;
            }

            public void setCsid(String csid) {
                this.myCsid = csid;
            }

            @XmlElement
            @Nullable
            public String getKey() {
                return this.myKey;
            }

            public void setKey(String key) {
                this.myKey = key;
            }

            @XmlElement
            @Nullable
            public String getName() {
                return this.myName;
            }

            public void setName(String name) {
                this.myName = name;
            }

            @XmlElement
            @Nullable
            public Map<String, Object> getParameters() {
                return this.myParameters;
            }

            public void setParameters(@Nullable Map<String, Object> parameters) {
                this.myParameters = JsonMapUtil.copyParameters(parameters, true, false, false);
            }

            public Builder removeParameter(String name) {
                return this.setParameter(name, null);
            }

            public Builder setParameter(String name, @Nullable Object value) {
                if (name == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    if (this.myParameters != null) {
                        this.myParameters.remove(name);
                    }
                } else {
                    JsonMapUtil.checkValidParameter(value);
                    if (this.myParameters == null) {
                        this.myParameters = new LinkedHashMap<String, Object>();
                    }
                    this.myParameters.put(name, JsonMapUtil.copyParameter(value, false));
                }
                return this;
            }

            public Builder setStringListParameter(String name, String ... values) {
                List<String> list = Arrays.asList(values);
                this.setParameter(name, list);
                return this;
            }

            @JsonIgnore
            public boolean isValid() {
                return this.myCsid != null && this.myCsid.length() > 0 && this.myKey != null && this.myKey.length() > 0;
            }

            @NotNull
            public Column build() throws IllegalStateException {
                if (!this.isValid()) {
                    throw new IllegalStateException("column builder is not in valid state: " + this);
                }
                return new Column(this.myCsid, this.myKey, this.myName, this.myParameters);
            }

            public String toString() {
                return "ViewSpecification.Column.Builder{csid='" + this.myCsid + '\'' + ", key='" + this.myKey + '\'' + ", name='" + this.myName + '\'' + ", parameters=" + this.myParameters + '}';
            }
        }
    }

    @XmlRootElement(name="view-specification")
    @XmlType(name="view-specification")
    public static class Builder
    implements Cloneable {
        private List<Column.Builder> myColumnBuilders = new ArrayList<Column.Builder>();
        private int myColumnDisplayMode = 1;
        private int myCsidSequence = -1;
        private List<String> myPins = new ArrayList<String>();

        public Builder() {
        }

        public Builder(@Nullable ViewSpecification specification) {
            if (specification != null) {
                for (Column column : specification.getColumns()) {
                    this.myColumnBuilders.add(new Column.Builder(column));
                }
                this.myColumnDisplayMode = specification.myColumnDisplayMode;
                this.myPins = new ArrayList<String>(specification.myPins);
            }
        }

        public Builder clone() {
            try {
                Builder r = (Builder)super.clone();
                r.myColumnBuilders = new ArrayList<Column.Builder>(r.myColumnBuilders);
                r.myPins = new ArrayList<String>(r.myPins);
                List<Column.Builder> cols = r.myColumnBuilders;
                for (int i = 0; i < cols.size(); ++i) {
                    Column.Builder col = cols.get(i);
                    cols.set(i, col == null ? null : col.clone());
                }
                return r;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Builder addColumns(Column.Builder ... columns) {
            if (columns == null) {
                return this;
            }
            Collections.addAll(this.myColumnBuilders, columns);
            this.invalidateCsidSequence();
            return this;
        }

        public Builder removeColumn(String csid) {
            Iterator<Column.Builder> ii = this.myColumnBuilders.iterator();
            while (ii.hasNext()) {
                Column.Builder column = ii.next();
                String columnCsid = column.getCsid();
                if ((csid != null || columnCsid != null) && (csid == null || !csid.equals(columnCsid))) continue;
                ii.remove();
                this.invalidateCsidSequence();
            }
            return this;
        }

        public Column.Builder addColumn(String key, String csid) {
            Column.Builder builder = new Column.Builder();
            builder.setCsid(csid);
            builder.setKey(key);
            this.myColumnBuilders.add(builder);
            this.invalidateCsidSequence();
            return builder;
        }

        public Column.Builder addColumn(String key) {
            return this.addColumn(key, this.getNextCsid());
        }

        public Builder addMainColumn() {
            this.addColumn("main", "main");
            return this;
        }

        public Builder addFieldColumn(String field) {
            this.addColumn("field").setParameter("field", field);
            return this;
        }

        public Builder addTimeAggregateColumn(String field) {
            this.addColumn("field").setParameter("field", field).setParameter("aggregate", "sum");
            return this;
        }

        public Builder addFieldSumColumn(String field) {
            this.addColumn("field").setParameter("field", field).setParameter("aggregate", "sum");
            return this;
        }

        public Builder addProgressColumn() {
            this.addColumn("progress");
            return this;
        }

        public Builder addTPColumn() {
            Column.Builder builder = this.addColumn("icons");
            builder.setName(StructureUtil.getText(null, null, "s.w.column.tp.label", new Object[0]));
            builder.setStringListParameter("fields", "issuetype", "priority");
            return this;
        }

        public Builder addIconsColumn(String ... fields) {
            Column.Builder builder = this.addColumn("icons");
            builder.setStringListParameter("fields", fields);
            return this;
        }

        @NotNull
        public ViewSpecification build() {
            ArrayList<Column> columns = new ArrayList<Column>(this.myColumnBuilders.size());
            for (Column.Builder columnBuilder : this.myColumnBuilders) {
                if (!columnBuilder.isValid()) continue;
                columns.add(columnBuilder.build());
            }
            return new ViewSpecification(columns, true, this.myColumnDisplayMode, this.myPins);
        }

        private void invalidateCsidSequence() {
            this.myCsidSequence = -1;
        }

        private String getNextCsid() {
            if (this.myCsidSequence < 0) {
                int max = 0;
                for (Column.Builder builder : this.myColumnBuilders) {
                    String csid = builder.getCsid();
                    if (csid == null) continue;
                    try {
                        max = Math.max(max, Integer.parseInt(csid));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.myCsidSequence = max;
            }
            return String.valueOf(++this.myCsidSequence);
        }

        @XmlElementRef
        @XmlElementWrapper(name="columns")
        @JsonDeserialize(contentAs=Column.Builder.class)
        @NotNull
        public List<Column.Builder> getColumns() {
            return this.myColumnBuilders;
        }

        public void setColumns(List<Column.Builder> columns) {
            this.myColumnBuilders = columns == null ? new ArrayList<Column.Builder>() : new ArrayList<Column.Builder>(columns);
        }

        public Builder setColumnDisplayMode(int columnDisplayMode) {
            this.myColumnDisplayMode = ColumnDisplayMode.isValid(columnDisplayMode) ? columnDisplayMode : 1;
            return this;
        }

        @XmlElement
        public int getColumnDisplayMode() {
            return this.myColumnDisplayMode;
        }

        public Builder setPins(List<String> pins) {
            this.myPins = pins == null ? new ArrayList<String>() : new ArrayList<String>(pins);
            return this;
        }

        @XmlElement
        public List<String> getPins() {
            return this.myPins;
        }

        public String toString() {
            return "ViewSpecification.Builder{columns=" + this.myColumnBuilders + ", columnDisplayMode='" + this.myColumnDisplayMode + '\'' + ", pins='" + this.myPins + '\'' + '}';
        }
    }
}

