/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.IntArray;
import com.almworks.integers.IntList;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongList;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class La<T, R>
implements Function<T, R>,
Predicate<T> {
    private static final La SELF = new La(){

        public Object la(Object argument) {
            return argument;
        }
    };
    private static final La TRUE = new La(){

        public Object la(Object argument) {
            return Boolean.TRUE;
        }
    };
    private static final La FALSE = new La(){

        public Object la(Object argument) {
            return Boolean.FALSE;
        }
    };
    private static final La NOT_NULL = new La<Object, Boolean>(){

        @Override
        public Boolean la(Object argument) {
            return argument != null;
        }
    };
    private static final La TO_STRING = new La<Object, String>(String.class){

        @Override
        public String la(Object argument) {
            return argument == null ? null : argument.toString();
        }
    };
    private final Class<R> rClass;

    protected La() {
        this.rClass = null;
    }

    protected La(Class<R> rClass) {
        this.rClass = rClass;
    }

    public abstract R la(T var1);

    @NotNull
    public static <T, R> La<T, R> adapt(final Function<T, R> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        return new La<T, R>(){

            @Override
            public R la(T argument) {
                return f.apply(argument);
            }
        };
    }

    @NotNull
    public static <T, R> La<T, R> constant(final R result) {
        if (result == Boolean.TRUE) {
            return TRUE;
        }
        if (result == Boolean.FALSE) {
            return FALSE;
        }
        return new La<T, R>(){

            @Override
            public R la(T argument) {
                return result;
            }
        };
    }

    public static <T> La<T, Boolean> constantFalse() {
        return FALSE;
    }

    public static <T> La<T, Boolean> constantTrue() {
        return TRUE;
    }

    @NotNull
    public static <T> La<T, Boolean> isEqual(final @Nullable T value) {
        final boolean isNull = value == null;
        return new La<T, Boolean>(){

            @Override
            public Boolean la(T argument) {
                return isNull ? argument == null : value.equals(argument);
            }
        };
    }

    @NotNull
    public static <T> La<T, Boolean> inCollection(final @Nullable Collection<T> collection) {
        if (collection == null) {
            return La.constant(false);
        }
        return new La<T, Boolean>(){

            @Override
            public Boolean la(T argument) {
                return collection.contains(argument);
            }
        };
    }

    @NotNull
    public static <T> La<T, Boolean> instanceOf(final @Nullable Class<? extends T> instanceClass) {
        if (instanceClass == null) {
            return La.constant(false);
        }
        return new La<T, Boolean>(){

            @Override
            public Boolean la(T argument) {
                return instanceClass.isInstance(argument);
            }
        };
    }

    @NotNull
    public static <T> La<Object, T> cast(final @Nullable Class<T> clazz) {
        if (clazz == null) {
            return La.constant(null);
        }
        return new La<Object, T>(){

            @Override
            public T la(Object argument) {
                return clazz.isInstance(argument) ? (Object)clazz.cast(argument) : null;
            }
        };
    }

    @NotNull
    public static <A, B, C> La<A, C> compose(final La<B, C> g, final La<A, ? extends B> f) {
        if (f == null) {
            throw new NullPointerException();
        }
        if (g == null) {
            throw new NullPointerException();
        }
        return new La<A, C>(g.rClass){

            @Override
            public C la(A argument) {
                return g.la(f.la(argument));
            }
        };
    }

    @NotNull
    public static <T> La<T, T> self() {
        return SELF;
    }

    @NotNull
    public static <T, R> La<T, R> fromMap(final Map<? super T, ? extends R> map, Class<R> rClass) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new La<T, R>(rClass){

            @Override
            public R la(T argument) {
                return map.get(argument);
            }
        };
    }

    @Override
    public final R apply(T from) {
        return this.la(from);
    }

    @Override
    public boolean test(T input) {
        return this.accepts(input);
    }

    @Override
    @NotNull
    public <A> La<A, R> apply(La<A, ? extends T> f) {
        return La.compose(this, f);
    }

    @NotNull
    public <A> La<T, A> supply(La<? super R, A> g) {
        return La.compose(g, this);
    }

    @NotNull
    public <D extends T> ArrayList<D> filter(@Nullable Iterable<D> collection) {
        ArrayList<D> r = new ArrayList<D>();
        if (collection != null) {
            for (D item : collection) {
                if (!this.accepts(item)) continue;
                r.add(item);
            }
        }
        return r;
    }

    @NotNull
    public <D extends T> Iterator<D> filter(@Nullable Iterator<D> iterator) {
        return iterator == null ? Collections.emptyIterator() : new FilterIterator<D>(iterator);
    }

    @NotNull
    public <D extends T> Iterable<D> filterIterable(@Nullable Iterable<D> iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return () -> new FilterIterator(iterable.iterator());
    }

    public boolean accepts(T value) {
        return this.acceptsResult(this.la(value));
    }

    private boolean acceptsResult(R value) {
        return value != null && !value.equals(false) && !value.equals(0) && !value.equals(0L);
    }

    @NotNull
    public HashSet<R> hashSet(@Nullable Collection<? extends T> from) {
        if (from == null) {
            return new HashSet();
        }
        return this.addTo(from, new HashSet(from.size()), true);
    }

    @NotNull
    public LinkedHashSet<R> linkedHashSet(@Nullable Collection<? extends T> from) {
        if (from == null) {
            return new LinkedHashSet();
        }
        return this.addTo(from, new LinkedHashSet(from.size()), true);
    }

    @NotNull
    public List<R> arrayList(T ... from) {
        return from == null || from.length == 0 ? Collections.emptyList() : this.arrayList((Collection<? extends T>)Arrays.asList(from));
    }

    public List<R> arrayList(@Nullable Collection<? extends T> from) {
        return this.arrayList(from, true);
    }

    @NotNull
    public Iterable<R> iterable(@Nullable Iterable<? extends T> from) {
        return () -> this.iterator(from);
    }

    @NotNull
    public Iterator<R> iterator(Iterable<? extends T> from) {
        Iterator<T> source;
        Iterator<T> iterator = source = from == null ? null : from.iterator();
        if (source == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return source.hasNext();
            }

            @Override
            public R next() {
                return La.this.la(source.next());
            }

            @Override
            public void remove() {
                source.remove();
            }
        };
    }

    @NotNull
    public List<R> arrayList(@Nullable Collection<? extends T> from, boolean acceptFalsy) {
        if (from == null) {
            return new ArrayList();
        }
        return this.addTo(from, new ArrayList(from.size()), acceptFalsy);
    }

    public List<R> arrayList(@Nullable Iterator<? extends T> from) {
        return this.arrayList(from, true);
    }

    public List<R> arrayList(@Nullable Iterator<? extends T> from, boolean acceptFalsy) {
        if (from == null) {
            return new ArrayList();
        }
        return this.addTo(from, new ArrayList(), acceptFalsy);
    }

    @NotNull
    public static <T> LongList longList(@Nullable Collection<T> collection, @NotNull La<? super T, Long> la) {
        if (collection == null || collection.isEmpty()) {
            return LongList.EMPTY;
        }
        LongArray result = new LongArray(collection.size());
        for (T element : collection) {
            Long value = la.la(element);
            if (value == null || value <= 0L) continue;
            result.add(value.longValue());
        }
        return result;
    }

    @NotNull
    public static <T> IntList intList(@Nullable Collection<T> collection, @NotNull La<? super T, Integer> la) {
        if (collection == null || collection.isEmpty()) {
            return IntList.EMPTY;
        }
        IntArray result = new IntArray(collection.size());
        for (T element : collection) {
            Integer value = la.la(element);
            if (value == null || value <= 0) continue;
            result.add(value.intValue());
        }
        return result;
    }

    @NotNull
    public <C extends Collection<R>> C addTo(@Nullable Collection<? extends T> from, @NotNull C to, boolean acceptFalsy) {
        if (from != null) {
            this.addTo(from.iterator(), to, acceptFalsy);
        }
        return to;
    }

    @NotNull
    public <C extends Collection<R>> C addTo(@Nullable Iterator<? extends T> from, @NotNull C to, boolean acceptFalsy) {
        if (from != null) {
            while (from.hasNext()) {
                T t = from.next();
                R r = this.la(t);
                if (!acceptFalsy && !this.acceptsResult(r)) continue;
                to.add(r);
            }
        }
        return to;
    }

    public <D extends T> Iterator<R> transform(Iterator<D> iterator) {
        return new TransformIterator<D>(iterator);
    }

    public <D extends T> Iterable<R> transformIterable(Iterable<D> iterable) {
        return () -> new TransformIterator(iterable.iterator());
    }

    @NotNull
    public R[] array(@Nullable Collection<? extends T> from) {
        return this.array(from, true);
    }

    @NotNull
    public R[] array(@Nullable Collection<? extends T> from, boolean acceptFalsy) {
        Class<R> cls = this.rClass;
        if (cls == null) {
            throw new UnsupportedOperationException("cannot create array without rClass (" + from + ")");
        }
        Object[] result = (Object[])Array.newInstance(cls, from == null ? 0 : from.size());
        if (from != null) {
            int i = 0;
            for (T t : from) {
                if (i >= result.length) {
                    throw new IllegalStateException("collection changed on the go");
                }
                R r = this.la(t);
                if (!acceptFalsy && !this.acceptsResult(r)) continue;
                result[i++] = r;
            }
            if (i < result.length) {
                result = Arrays.copyOf(result, i);
            }
        }
        return result;
    }

    @NotNull
    public Map<R, T> mapInto(@Nullable Collection<? extends T> fromCollection, @NotNull Map<R, T> toMap) {
        return this.mapInto(fromCollection, toMap, La.self());
    }

    @NotNull
    public <V, C extends T> Map<R, V> mapInto(@Nullable Collection<C> fromCollection, @NotNull Map<R, V> toMap, @NotNull La<? super C, ? extends V> valueFunction) {
        if (fromCollection != null) {
            for (C value : fromCollection) {
                R key = this.la(value);
                if (key == null) continue;
                toMap.put(key, valueFunction.la(value));
            }
        }
        return toMap;
    }

    @NotNull
    public <C extends T> Map<R, C> hashMap(@Nullable Collection<C> collection) {
        return this.hashMap(collection, La.self());
    }

    @NotNull
    public <V, C extends T> Map<R, V> hashMap(@Nullable Collection<C> collection, @NotNull La<? super C, V> valueFunction) {
        HashMap map = new HashMap(collection == null ? 0 : collection.size());
        return this.mapInto(collection, map, valueFunction);
    }

    @NotNull
    public <V, C extends T> Map<R, V> linkedHashMap(@Nullable Collection<C> collection, @NotNull La<? super C, V> valueFunction) {
        LinkedHashMap map = new LinkedHashMap(collection == null ? 0 : collection.size());
        return this.mapInto(collection, map, valueFunction);
    }

    public int indexOf(@Nullable List<? extends T> list, R sample) {
        if (list == null) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            R v = this.la(list.get(i));
            if ((sample != null || v != null) && (sample == null || !sample.equals(v))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(@Nullable List<? extends T> list, R sample) {
        if (list == null) {
            return -1;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            R v = this.la(list.get(i));
            if ((sample != null || v != null) && (sample == null || !sample.equals(v))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public <X extends T> X find(@Nullable Collection<X> collection, R sample) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        for (X value : collection) {
            R r = this.la(value);
            if (r == null && sample == null) {
                return value;
            }
            if (r == null || !r.equals(sample)) continue;
            return value;
        }
        return null;
    }

    public boolean any(@Nullable Iterable<? extends T> sequence) {
        if (sequence == null) {
            return false;
        }
        for (T value : sequence) {
            if (!this.accepts(value)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public La<T, Boolean> not() {
        final La positive = this;
        return new La<T, Boolean>(){

            @Override
            public Boolean la(T argument) {
                return !positive.accepts(argument);
            }
        };
    }

    public La<T, Boolean> and(final La<? super T, ?> second) {
        final La first = this;
        return new La<T, Boolean>(){

            @Override
            public Boolean la(T argument) {
                return first.accepts(argument) && second.accepts(argument);
            }
        };
    }

    public La<T, R> memoize() {
        final La delegate = this;
        final HashMap map = new HashMap();
        return new La<T, R>(){

            @Override
            public R la(T argument) {
                Object result = map.get(argument);
                if (result == null && !map.containsKey(argument)) {
                    result = delegate.la(argument);
                    map.put(argument, result);
                }
                return result;
            }
        };
    }

    public La<T, R> memoizeConcurrent() {
        final La delegate = this;
        final ConcurrentHashMap map = new ConcurrentHashMap();
        return new La<T, R>(){

            @Override
            public R la(T argument) {
                assert (argument != null);
                Object result = map.get(argument);
                if (result == null) {
                    result = delegate.la(argument);
                    assert (result != null);
                    map.putIfAbsent(argument, result);
                }
                return result;
            }
        };
    }

    public Comparator<T> comparator(Comparator<? super R> comparator) {
        return new LaComparator(this, comparator);
    }

    public static <A, B extends Comparable<B>> Comparator<A> comparator(La<A, B> function) {
        return function.comparator(new ComparableComparator());
    }

    public <C extends Iterable<? extends T>> La<C, List<R>> liftToList() {
        final La transform = this;
        return new La<C, List<R>>(){

            @Override
            public List<R> la(C argument) {
                if (argument == null) {
                    return null;
                }
                Iterator it = argument.iterator();
                if (it.hasNext()) {
                    return transform.arrayList(it);
                }
                return Collections.emptyList();
            }
        };
    }

    public static <T> La<T, Boolean> notNull() {
        return NOT_NULL;
    }

    public static <T> La<T, String> stringValue() {
        return TO_STRING;
    }

    public static <A, B> La<A, B> notNull(final La<A, B> la, final B onNull) {
        return new La<A, B>(la.rClass){

            @Override
            public B la(A argument) {
                Object result = la.la(argument);
                return result == null ? onNull : result;
            }
        };
    }

    public Collection<R> image(Collection<T> set) {
        return this.image(set, false);
    }

    private Collection<R> image(final Collection<T> set, final boolean includeFalsy) {
        if (set == null) {
            return Collections.emptyList();
        }
        return new AbstractCollection<R>(){

            @Override
            @NotNull
            public Iterator<R> iterator() {
                Iterator it = La.this.transform(set.iterator());
                if (!includeFalsy) {
                    it = La.self().filter(it);
                }
                return it;
            }

            @Override
            public int size() {
                if (includeFalsy) {
                    return set.size();
                }
                int count = 0;
                for (Object v : set) {
                    if (!La.this.accepts(v)) continue;
                    ++count;
                }
                return count;
            }
        };
    }

    public class FilterIterator<D extends T>
    implements Iterator<D> {
        private final Iterator<D> myOuter;
        private Boolean hasNext = null;
        private D next;

        public FilterIterator(Iterator<D> iterator) {
            this.myOuter = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext == null) {
                this.hasNext = this.calcHasNext();
            }
            return this.hasNext;
        }

        private boolean calcHasNext() {
            while (this.myOuter.hasNext()) {
                this.next = this.myOuter.next();
                if (!La.this.accepts(this.next)) continue;
                return true;
            }
            return false;
        }

        @Override
        public D next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class TransformIterator<D extends T>
    implements Iterator<R> {
        private final Iterator<D> mySourceIterator;

        public TransformIterator(Iterator<D> iterator) {
            this.mySourceIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.mySourceIterator.hasNext();
        }

        @Override
        public R next() {
            return La.this.la(this.mySourceIterator.next());
        }

        @Override
        public void remove() {
            this.mySourceIterator.remove();
        }
    }

    public static class LaComparator<A, B>
    implements Comparator<A> {
        private final La<A, B> myFunction;
        private final Comparator<? super B> myComparator;

        public LaComparator(La<A, B> function, Comparator<? super B> comparator) {
            if (function == null) {
                throw new IllegalArgumentException("function is null");
            }
            if (comparator == null) {
                throw new IllegalArgumentException("comparator is null");
            }
            this.myFunction = function;
            this.myComparator = comparator;
        }

        @Override
        public int compare(A o1, A o2) {
            B b1 = this.myFunction.apply(o1);
            B b2 = this.myFunction.apply(o2);
            return this.myComparator.compare(b1, b2);
        }
    }

    public static class ComparableComparator<B extends Comparable<B>>
    implements Comparator<B> {
        @Override
        public int compare(B b1, B b2) {
            if (b1 == null) {
                return b2 == null ? 0 : -1;
            }
            if (b2 == null) {
                return 1;
            }
            return b1.compareTo(b2);
        }
    }
}

