/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.jira.structure.api.util.ComparableTuple;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class TotalOrder {
    public static final Comparator<ValueWrapper> COMPARATOR = new ValueComparator();
    @Nullable
    private final Locale myCaseInsensitiveLocale;
    @Nullable
    private final Collator myCollator;

    private TotalOrder(@Nullable Locale caseInsensitiveLocale, @Nullable Collator collator) {
        assert (caseInsensitiveLocale == null || collator == null);
        this.myCaseInsensitiveLocale = caseInsensitiveLocale;
        this.myCollator = collator;
    }

    public static TotalOrder withStrictStringComparison() {
        return new TotalOrder(null, null);
    }

    public static TotalOrder withCaseInsensitiveStringComparison() {
        return TotalOrder.withCaseInsensitiveStringComparison(null);
    }

    public static TotalOrder withCaseInsensitiveStringComparison(Locale locale) {
        return new TotalOrder(locale == null ? Locale.ROOT : locale, null);
    }

    public static TotalOrder withCollatorStringComparison(Locale locale) {
        return new TotalOrder(null, TotalOrder.getCollator(locale));
    }

    public static TotalOrder withCollatorStringComparison(Locale locale, int strength) {
        Collator collator = TotalOrder.getCollator(locale);
        collator.setStrength(strength);
        return new TotalOrder(null, collator);
    }

    public static TotalOrder withCollatorStringComparison(Locale locale, int strength, int decomposition) {
        Collator collator = TotalOrder.getCollator(locale);
        collator.setStrength(strength);
        collator.setDecomposition(decomposition);
        return new TotalOrder(null, collator);
    }

    public static TotalOrder withCollator(Collator collator) {
        return new TotalOrder(null, collator);
    }

    private static Collator getCollator(Locale locale) {
        Collator collator = Collator.getInstance(locale);
        if (collator == null) {
            throw new IllegalArgumentException("cannot get collator for locale " + locale);
        }
        return collator;
    }

    public ValueWrapper wrap(Object value) {
        return new ValueWrapper(this.prepareValue(value));
    }

    public <T> PayloadWrapper<T> wrap(Object value, T payload) {
        return new PayloadWrapper<T>(this.prepareValue(value), payload);
    }

    private Object prepareValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return ComparableTuple.of(((Number)value).longValue());
        }
        if (value instanceof Double || value instanceof Float) {
            return ComparableTuple.of(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            if (this.myCaseInsensitiveLocale != null) {
                return ((String)value).toLowerCase(this.myCaseInsensitiveLocale);
            }
            if (this.myCollator != null) {
                return this.myCollator.getCollationKey((String)value);
            }
        }
        return value;
    }

    public int compare(Object o1, Object o2) {
        ValueWrapper v1 = this.wrap(o1);
        ValueWrapper v2 = this.wrap(o2);
        return COMPARATOR.compare(v1, v2);
    }

    public class ValueWrapper {
        private final Object myValue;
        private final Class myClass;
        private final boolean myComparable;

        public ValueWrapper(Object value) {
            this.myValue = value;
            this.myClass = value == null ? null : value.getClass();
            this.myComparable = value instanceof Comparable;
        }

        public Object getValue() {
            return this.myValue;
        }

        public Class getValueClass() {
            return this.myClass;
        }

        public boolean isComparable() {
            return this.myComparable;
        }

        public TotalOrder getOrder() {
            return TotalOrder.this;
        }

        public String toString() {
            return String.valueOf(this.myValue);
        }
    }

    public class PayloadWrapper<T>
    extends ValueWrapper {
        private final T myPayload;

        public PayloadWrapper(Object value, T payload) {
            super(value);
            this.myPayload = payload;
        }

        public T getPayload() {
            return this.myPayload;
        }

        @Override
        public String toString() {
            return super.toString() + "(" + this.myPayload + ")";
        }
    }

    private static final class ValueComparator
    implements Comparator<ValueWrapper> {
        private static final Class[] CLASS_PRECEDENCE = new Class[]{ComparableTuple.class, String.class, CollationKey.class};

        private ValueComparator() {
        }

        @Override
        public int compare(ValueWrapper o1, ValueWrapper o2) {
            assert (o1 != null);
            assert (o2 != null);
            if (o1 == o2) {
                return 0;
            }
            assert (o1.getOrder() == o2.getOrder()) : "cannot compare values from two different TotalOrder instances " + o1 + " " + o2;
            Class c1 = o1.getValueClass();
            Class c2 = o2.getValueClass();
            if (c1 == null) {
                return c2 == null ? 0 : 1;
            }
            if (c2 == null) {
                return -1;
            }
            if (c1 == c2) {
                Object v1 = o1.getValue();
                Object v2 = o2.getValue();
                assert (v1 != null) : o1;
                assert (v2 != null) : o2;
                if (o1.isComparable()) {
                    assert (o2.isComparable()) : o1 + " " + o2;
                    return ((Comparable)v1).compareTo(v2);
                }
                return v1.toString().compareTo(v2.toString());
            }
            for (Class cls : CLASS_PRECEDENCE) {
                if (c1 == cls) {
                    return -1;
                }
                if (c2 != cls) continue;
                return 1;
            }
            return c1.getSimpleName().compareTo(c2.getSimpleName());
        }
    }
}

