/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.forest;

import com.almworks.integers.IntArray;
import com.almworks.integers.LongArray;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.integers.LongList;
import com.almworks.integers.WritableIntList;
import com.almworks.integers.WritableLongList;
import com.almworks.jira.structure.api.error.StructureException;
import com.almworks.jira.structure.api.forest.raw.ArrayForest;
import com.almworks.jira.structure.api.forest.raw.Forest;
import com.atlassian.annotations.PublicApi;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@PublicApi
@Immutable
public abstract class ForestChange {
    private ForestChange() {
    }

    public static ForestChange add(long under, long after, Forest added) {
        return new Add(added, under, after);
    }

    public static ForestChange move(long under, long after, LongList rows) {
        return new Move(rows, under, after);
    }

    public static ForestChange remove(LongList rows) {
        return new Remove(rows);
    }

    public static ForestChange reorder(long under, LongList children) {
        return new Reorder(under, children);
    }

    public abstract void apply(@NotNull ArrayForest var1);

    public abstract void accept(Visitor var1);

    public static class Reorder
    extends ForestChange {
        private final long myUnder;
        @NotNull
        private final LongList myChildren;

        public Reorder(long under, @NotNull LongList children) {
            if (children == null) {
                throw new IllegalArgumentException("children must not be null");
            }
            this.myUnder = under;
            this.myChildren = LongArray.copy((LongIterable)children);
        }

        public long getUnder() {
            return this.myUnder;
        }

        @NotNull
        public LongList getChildren() {
            return this.myChildren;
        }

        @Override
        public void apply(@NotNull ArrayForest forest) {
            forest.reorder(this.myUnder, this.myChildren);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reorder reorder = (Reorder)o;
            if (this.myUnder != reorder.myUnder) {
                return false;
            }
            return this.myChildren.equals(reorder.myChildren);
        }

        public int hashCode() {
            int result = (int)(this.myUnder ^ this.myUnder >>> 32);
            result = 31 * result + this.myChildren.hashCode();
            return result;
        }

        public String toString() {
            return this.myUnder + "#" + this.myChildren;
        }
    }

    public static class Move
    extends ForestChange {
        @NotNull
        private final LongList myMovedRows;
        private final long myUnder;
        private final long myAfter;

        public Move(@NotNull LongList movedRows, long under, long after) {
            if (movedRows == null) {
                throw new IllegalArgumentException("movedRows must not be null");
            }
            this.myMovedRows = LongArray.copy((LongIterable)movedRows);
            this.myUnder = under;
            this.myAfter = after;
        }

        @NotNull
        public LongList getMovedRows() {
            return this.myMovedRows;
        }

        public long getUnder() {
            return this.myUnder;
        }

        public long getAfter() {
            return this.myAfter;
        }

        @Override
        public void apply(@NotNull ArrayForest forest) {
            long after = this.myAfter;
            for (LongIterator ii : this.myMovedRows) {
                try {
                    forest.moveSubtree(ii.value(), this.myUnder, after);
                }
                catch (StructureException structureException) {
                    // empty catch block
                }
                after = ii.value();
            }
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Move move = (Move)o;
            if (this.myAfter != move.myAfter) {
                return false;
            }
            if (this.myUnder != move.myUnder) {
                return false;
            }
            return this.myMovedRows.equals(move.myMovedRows);
        }

        public int hashCode() {
            int result = this.myMovedRows.hashCode();
            result = 31 * result + (int)(this.myUnder ^ this.myUnder >>> 32);
            result = 31 * result + (int)(this.myAfter ^ this.myAfter >>> 32);
            return result;
        }

        public String toString() {
            return this.myUnder + "." + this.myAfter + "<-" + this.myMovedRows;
        }
    }

    public static class Remove
    extends ForestChange {
        @NotNull
        private final LongList myRemovedRows;

        public Remove(@NotNull LongList removedRows) {
            if (removedRows == null) {
                throw new IllegalArgumentException("removedRows must not be null");
            }
            assert (!removedRows.isEmpty());
            this.myRemovedRows = LongArray.copy((LongIterable)removedRows);
        }

        @NotNull
        public LongList getRemovedRows() {
            return this.myRemovedRows;
        }

        @Override
        public void apply(@NotNull ArrayForest forest) {
            for (LongIterator ii : this.myRemovedRows) {
                forest.removeSubtree(ii.value());
            }
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Remove remove = (Remove)o;
            return this.myRemovedRows.equals(remove.myRemovedRows);
        }

        public int hashCode() {
            return this.myRemovedRows.hashCode();
        }

        public String toString() {
            return "-" + this.myRemovedRows;
        }
    }

    public static class Add
    extends ForestChange {
        @NotNull
        private final Forest myAddedForest;
        private final long myUnder;
        private final long myAfter;

        public Add(@NotNull Forest addedForest, long under, long after) {
            if (addedForest == null) {
                throw new IllegalArgumentException("addedForest must not be null");
            }
            this.myAddedForest = ArrayForest.ensureImmutability(addedForest);
            this.myUnder = under;
            this.myAfter = after;
        }

        public Add(long row, long under, long after) {
            this(new ArrayForest((WritableLongList)LongArray.create((long[])new long[]{row}), (WritableIntList)IntArray.create((int[])new int[]{0}), true).makeImmutable(), under, after);
        }

        @NotNull
        public Forest getAddedForest() {
            return this.myAddedForest;
        }

        public long getUnder() {
            return this.myUnder;
        }

        public long getAfter() {
            return this.myAfter;
        }

        @Override
        public void apply(@NotNull ArrayForest forest) {
            forest.addForest(this.myUnder, this.myAfter, this.myAddedForest);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Add add = (Add)o;
            if (this.myAfter != add.myAfter) {
                return false;
            }
            if (this.myUnder != add.myUnder) {
                return false;
            }
            return this.myAddedForest.equals(add.myAddedForest);
        }

        public int hashCode() {
            int result = this.myAddedForest.hashCode();
            result = 31 * result + (int)(this.myUnder ^ this.myUnder >>> 32);
            result = 31 * result + (int)(this.myAfter ^ this.myAfter >>> 32);
            return result;
        }

        public String toString() {
            return this.myUnder + "." + this.myAfter + "+" + this.myAddedForest;
        }
    }

    public static interface Visitor {
        public void visit(Add var1);

        public void visit(Move var1);

        public void visit(Remove var1);

        public void visit(Reorder var1);
    }
}

