/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.event;

import com.almworks.integers.LongList;
import com.almworks.jira.structure.api.event.JiraChangeEvent;
import com.almworks.jira.structure.api.event.JiraChangeType;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueChangeEvent
extends JiraChangeEvent {
    private final long myIssueId;
    @Nullable
    private final IssueEvent myJiraEvent;

    public IssueChangeEvent(@NotNull JiraChangeType changeType, long issueId, @Nullable IssueEvent jiraEvent) {
        super(changeType);
        this.myIssueId = issueId;
        this.myJiraEvent = jiraEvent;
    }

    public IssueChangeEvent(@NotNull JiraChangeType changeType, long issueId) {
        this(changeType, issueId, null);
    }

    public IssueChangeEvent(@NotNull JiraChangeType changeType, @NotNull IssueEvent jiraEvent) {
        super(changeType);
        Long issueId;
        Issue issue;
        this.myJiraEvent = jiraEvent;
        long id = 0L;
        if (jiraEvent != null && (issue = jiraEvent.getIssue()) != null && (issueId = issue.getId()) != null) {
            id = issueId;
        }
        assert (id != 0L) : (Object)((Object)changeType) + " " + jiraEvent;
        this.myIssueId = id;
    }

    public long getIssueId() {
        return this.myIssueId;
    }

    @Nullable
    public IssueEvent getJiraEvent() {
        return this.myJiraEvent;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getChangeType()) + "(" + this.myIssueId + ')';
    }

    @Override
    public LongList getAffectedIssuesSorted() {
        return new LongList.Single(this.myIssueId);
    }

    public static long getIssueId(JiraChangeEvent event) {
        if (event instanceof IssueChangeEvent) {
            return ((IssueChangeEvent)event).getIssueId();
        }
        return 0L;
    }
}

