/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.extension.license;

import com.almworks.jira.structure.api.extension.license.LicenseException;
import com.almworks.jira.structure.api.extension.license.StructureLicenseHosting;
import com.almworks.jira.structure.api.extension.license.StructureLicenseType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LicenseData {
    public static final LicenseData DISABLED = new Disabled();

    public String getLicensee();

    public StructureLicenseType getLicenseType();

    @Nullable
    public String getSerial();

    public long getSerialNumber();

    public long getExpirationTimestamp();

    public long getMaintenanceExpirationDate();

    public Collection<String> getLicensedServers();

    public boolean isServerLocked();

    public int getMaximumNumberOfUsers();

    public boolean isUnlimitedNumberOfUsers();

    public void extraChecks() throws LicenseException;

    public boolean hasExpiration();

    public boolean hasMaintenanceExpiration();

    public boolean isMarketplaceLicense();

    default public boolean isDataCenterCompatible() {
        return this.getLicenseHosting() != StructureLicenseHosting.SERVER;
    }

    @NotNull
    default public StructureLicenseHosting getLicenseHosting() {
        return StructureLicenseHosting.LEGACY;
    }

    public static class Disabled
    implements LicenseData {
        @Override
        public String getLicensee() {
            return "--";
        }

        @Override
        public StructureLicenseType getLicenseType() {
            return StructureLicenseType.DISABLED;
        }

        @Override
        @Nullable
        public String getSerial() {
            return null;
        }

        @Override
        public long getSerialNumber() {
            return 0L;
        }

        @Override
        public long getExpirationTimestamp() {
            return 0L;
        }

        @Override
        public long getMaintenanceExpirationDate() {
            return 0L;
        }

        @Override
        public Collection<String> getLicensedServers() {
            return null;
        }

        @Override
        public boolean isServerLocked() {
            return false;
        }

        @Override
        public int getMaximumNumberOfUsers() {
            return 0;
        }

        @Override
        public boolean isUnlimitedNumberOfUsers() {
            return false;
        }

        @Override
        public void extraChecks() throws LicenseException {
        }

        @Override
        public boolean hasExpiration() {
            return false;
        }

        @Override
        public boolean hasMaintenanceExpiration() {
            return false;
        }

        @Override
        public boolean isMarketplaceLicense() {
            return false;
        }
    }
}

