/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.view;

import com.almworks.jira.structure.api.permissions.PermissionRule;
import com.almworks.jira.structure.api.permissions.PermissionSubject;
import com.almworks.jira.structure.api.util.StructureUtil;
import com.almworks.jira.structure.api.view.ViewSpecification;
import com.atlassian.annotations.PublicApi;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class StructureViewBean {
    public static final StructureViewBean EMPTY = new StructureViewBean(0L, "", "", null, null, ViewSpecification.EMPTY);
    private final long myId;
    private final String myName;
    private final String myDescription;
    private final PermissionSubject myOwner;
    private final List<PermissionRule> myPermissions;
    private final ViewSpecification mySpecification;

    private StructureViewBean(Long id, String name, String description, PermissionSubject owner, List<PermissionRule> permissions, ViewSpecification specification) {
        this.myId = id == null ? 0L : id;
        this.myName = name == null ? "" : name;
        this.myDescription = description == null ? "" : description;
        this.myOwner = owner;
        this.myPermissions = permissions;
        this.mySpecification = specification == null ? ViewSpecification.EMPTY : specification;
    }

    public long getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    public PermissionSubject getOwner() {
        return PermissionSubject.clone(this.myOwner);
    }

    public List<PermissionRule> getPermissions() {
        return StructureUtil.copyPermissions(this.myPermissions);
    }

    @NotNull
    public ViewSpecification getSpecification() {
        return this.mySpecification;
    }

    public String toString() {
        return "StructureViewBean{id=" + this.myId + ", name='" + this.myName + '\'' + ", description='" + this.myDescription + '\'' + ", owner=" + this.myOwner + ", permissions=" + this.myPermissions + ", specification=" + this.mySpecification + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructureViewBean that = (StructureViewBean)o;
        if (this.myId != that.myId) {
            return false;
        }
        if (!this.myDescription.equals(that.myDescription)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (this.myOwner != null ? !this.myOwner.equals(that.myOwner) : that.myOwner != null) {
            return false;
        }
        if (this.myPermissions != null ? !this.myPermissions.equals(that.myPermissions) : that.myPermissions != null) {
            return false;
        }
        return this.mySpecification.equals(that.mySpecification);
    }

    public int hashCode() {
        int result = (int)(this.myId ^ this.myId >>> 32);
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myDescription.hashCode();
        result = 31 * result + (this.myOwner != null ? this.myOwner.hashCode() : 0);
        result = 31 * result + (this.myPermissions != null ? this.myPermissions.hashCode() : 0);
        result = 31 * result + this.mySpecification.hashCode();
        return result;
    }

    @XmlRootElement(name="structure-view")
    @XmlType(name="structure-view", propOrder={"id", "name", "description", "owner", "permissions", "specification"})
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    public static class Builder
    implements Cloneable {
        private Long myId;
        private String myName;
        private String myDescription;
        private PermissionSubject myOwner;
        private List<PermissionRule> myPermissions;
        private ViewSpecification.Builder mySpecification;

        public Builder() {
        }

        public Builder(@Nullable StructureViewBean bean) {
            if (bean != null) {
                this.myId = bean.getId();
                this.myName = bean.getName();
                this.myDescription = bean.getDescription();
                this.myOwner = bean.getOwner();
                this.myPermissions = bean.getPermissions();
                this.mySpecification = new ViewSpecification.Builder(bean.getSpecification());
            }
        }

        public Builder clone() {
            try {
                Builder r = (Builder)super.clone();
                r.myOwner = PermissionSubject.clone(r.myOwner);
                r.myPermissions = StructureUtil.copyPermissionsOrNull(r.myPermissions);
                r.mySpecification = r.mySpecification == null ? null : r.mySpecification.clone();
                return r;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void updatePropertiesOf(Builder target) {
            if (this.myId != null) {
                target.setId(this.myId);
            }
            if (this.myName != null) {
                target.setName(this.myName);
            }
            if (this.myDescription != null) {
                target.setDescription(this.myDescription);
            }
            if (this.myOwner != null) {
                target.setOwner(this.myOwner);
            }
            if (this.myPermissions != null) {
                target.setPermissions(this.myPermissions);
            }
            if (this.mySpecification != null) {
                target.setSpecification(this.mySpecification);
            }
        }

        @XmlAttribute
        public Long getId() {
            return this.myId;
        }

        public void setId(Long id) {
            this.myId = id;
        }

        @XmlElement
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @XmlElement
        public String getDescription() {
            return this.myDescription;
        }

        public void setDescription(String description) {
            this.myDescription = description;
        }

        @XmlElement
        public PermissionSubject getOwner() {
            return PermissionSubject.clone(this.myOwner);
        }

        public boolean hasOwner() {
            return this.myOwner != null;
        }

        public void setOwner(PermissionSubject owner) {
            this.myOwner = PermissionSubject.clone(owner);
        }

        @XmlElementRef
        @XmlElementWrapper(name="permissions")
        @NotNull
        public List<PermissionRule> getPermissions() {
            return StructureUtil.copyPermissions(this.myPermissions);
        }

        public boolean hasPermissions() {
            return this.myPermissions != null;
        }

        public void setPermissions(@Nullable Collection<? extends PermissionRule> permissions) {
            this.myPermissions = StructureUtil.copyPermissionsOrNull(permissions);
        }

        @XmlAttribute
        public ViewSpecification.Builder getSpecification() {
            return this.mySpecification;
        }

        public void setSpecification(ViewSpecification.Builder specification) {
            this.mySpecification = specification;
        }

        @JsonIgnore
        public boolean isValid() {
            return this.myId != null && this.myId != 0L && this.isValidExceptId();
        }

        @JsonIgnore
        public boolean isValidExceptId() {
            return this.myName != null && this.myName.trim().length() > 0 && this.mySpecification != null;
        }

        @NotNull
        public StructureViewBean build() throws IllegalStateException {
            if (!this.isValid()) {
                throw new IllegalStateException("builder is not in valid state: " + this);
            }
            PermissionSubject owner = PermissionSubject.clone(this.myOwner);
            List<PermissionRule> permissions = StructureUtil.copyPermissions(this.myPermissions);
            ViewSpecification spec = this.mySpecification.build();
            return new StructureViewBean(this.myId, this.myName, this.myDescription, owner, permissions, spec);
        }

        public String toString() {
            return "StructureViewBean.Builder{id=" + this.myId + ", name='" + this.myName + '\'' + ", description='" + this.myDescription + '\'' + ", owner=" + this.myOwner + ", permissions=" + this.myPermissions + ", specification=" + this.mySpecification + '}';
        }
    }
}

