package com.almworks.jira.structure.api.attribute.loader.builder;

import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeContext;
import com.almworks.jira.structure.api.row.StructureRow;

import java.util.function.BiFunction;
import java.util.function.Function;

public class SingleRowAttributeLoaderBuilder<T> extends ArbitraryDependenciesAttributeLoaderBuilder<T, SingleRowAttributeLoaderBuilder<T>> {
  private BiFunction<StructureRow, SingleRowAttributeContext, AttributeValue<T>> myValueFunction;
  private RowPreloadFunction myPreloadFunction;
  private boolean myWholeForestDependent;

  public SingleRowAttributeLoaderBuilder<T> valueFunctionAV(BiFunction<StructureRow, SingleRowAttributeContext, AttributeValue<T>> valueFunction) {
    myValueFunction = valueFunction;
    return self();
  }

  public SingleRowAttributeLoaderBuilder<T> valueFunctionAV(Function<StructureRow,  AttributeValue<T>> valueFunction) {
    return valueFunctionAV((row, ctx) -> valueFunction.apply(row));
  }

  public SingleRowAttributeLoaderBuilder<T> valueFunction(BiFunction<StructureRow, SingleRowAttributeContext, T> valueFunction) {
    return valueFunctionAV((row, ctx) -> AttributeValue.ofNullable(valueFunction.apply(row, ctx)));
  }

  public SingleRowAttributeLoaderBuilder<T> valueFunction(Function<StructureRow,  T> valueFunction) {
    return valueFunctionAV((row, ctx) -> AttributeValue.ofNullable(valueFunction.apply(row)));
  }

  public SingleRowAttributeLoaderBuilder<T> preload(RowPreloadFunction preloadFunction) {
    myPreloadFunction = preloadFunction;
    return self();
  }

  public SingleRowAttributeLoaderBuilder<T> dependsOnWholeForest() {
    myWholeForestDependent = true;
    return self();
  }

  public BaseSingleRowAttributeLoader<T> build() {
    return new BaseSingleRowAttributeLoader<>(
      notNull(myAttributeSpec, "attributeSpec"),
      nullableCollectionOfNonNulls(buildDependencies(), "dependencies"),
      nullableCollectionOfNonNulls(buildContextDependencies(), "contextDependencies"),
      myCachingStrategy,
      myGlobalTrail,
      notNull(myValueFunction, "valueFunction"),
      myPreloadFunction,
      myWholeForestDependent
    );
  }
}
