package com.almworks.jira.structure.api.backup;

import org.jetbrains.annotations.NotNull;

/**
 * <p>The backup manager is responsible for backup and restore of the structure data. You use it by
 * creating an instance of a corresponding operation (for example, {@link BackupOperation},
 * setting up the parameters and running the job.</p>
 *
 * <p>Only Structure plugin's data is saved and restored.</p>
 *
 * <p>This manager does not check permissions of the current user. If operation is started
 * by the user, the calling code should check for permissions on its own.</p>
 *
 * @author Igor Sereda
 */
public interface StructureBackupManager {
  /**
   * Creates an instance of backup operation.
   *
   * @return backup operation
   */
  @NotNull
  BackupOperation backup();

  /**
   * Creates an instance of restore operation.
   *
   * @return restore operation
   */
  @NotNull
  RestoreOperation restore();

}
