package com.almworks.jira.structure.api.lifecycle;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.user.ApplicationUser;
import org.jetbrains.annotations.NotNull;

@Internal
public interface CachingComponent {
  void clearCaches();

  /**
   * Clear all cached data associated with the specified user.
   * 
   * If the component doesn't store any data associated with user (i.e., user is not a part of a cache entry key),
   * this method mustn't do anything.
   * 
   * If the component cannot selectively clear entries for one user, it might clear more, but it must ensure
   * that all related entries are cleared.
   * 
   * @param user the user for which to clear the cached data
   * */
  void clearUserCaches(@NotNull ApplicationUser user);
}
