package com.almworks.jira.structure.api.permissions;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;

/**
 * App-level permission.
 * @see CoreAppPermissions
 * @see com.almworks.jira.structure.api.settings.StructureConfiguration
 */
@PublicApi
public final class StructureAppPermission {
  @NotNull
  private final String myKey;

  StructureAppPermission(@NotNull String key) {
    myKey = key;
  }

  /**
   * Returns a string key that uniquely identifies this permission.
   */
  @NotNull
  public String getKey() {
    return myKey;
  }

  @Override
  public String toString() {
    return myKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StructureAppPermission that = (StructureAppPermission) o;
    return myKey.equals(that.myKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(myKey);
  }
}
