package com.almworks.jira.structure.api.backup;

import com.almworks.integers.*;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.item.ItemIdentitySet;
import org.jetbrains.annotations.NotNull;

import java.util.*;

public interface ErrorsContainer {
  /**
   * @return map of the issues that were not found in JIRA. Key is the issue ID, and value is a
   * message with some other details of the issue
   */
  @NotNull
  LongObjMap<String> getInvalidIssueMessages();

  /**
   * @return map of the items that were not resolved. Key is the item ID, and value is a
   * message with some other details of the item
   */
  @NotNull
  Map<ItemIdentity, String> getInvalidItemMessages();

  /**
   * @return map of structures that contain items that were not resolved. Key is the structure ID, and value is a
   * list of item IDs that were not resolved.
   */
  @NotNull
  LongObjMap<ItemIdentitySet> getInvalidStructureItems();

  /**
   * @return map of structures whose change histories contain items that were not resolved. Key is the structure ID,
   * and value is a list of item IDs that were not resolved.
   */
  @NotNull
  LongObjMap<ItemIdentitySet> getInvalidHistoryItems();

  @NotNull
  LongObjMap<String> getInvalidSynchronizerMessages();

  @NotNull
  LongObjMap<? extends LongList> getInvalidStructureSynchronizers();

  @NotNull
  LongObjMap<List<String>> getStructureOtherProblems();

  @NotNull
  LongObjMap<Set<String>> getStructureFieldResolutionProblems();

  @NotNull
  List<String> getOtherProblems();

  @NotNull
  LongSortedSet getInvalidStructures();
}
