package com.almworks.jira.structure.api.export;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

/**
 * <p>{@code ExportColumn} represents a single column in the underlying table-like medium (e.g. an Excel sheet or an
 * HTML table) that a structure can be exported into. There is a one-to-one correspondence between {@code ExportColumn}
 * and {@link ExportRenderer} instances. During export a new {@code ExportColumn} is created for each renderer and
 * passed to it for configuring.</p>
 *
 * <p>Each {@code ExportColumn} has a header cell that the renderer should use to set the column name. Media-specific
 * column sub-interfaces can add other methods for configuring the column.</p>
 *
 * @param <C> The type of the header cell.
 *
 * @see ExportCell
 * @see ExportRenderer
 */
@PublicApi
public interface ExportColumn<C extends ExportCell> {
  /**
   * @return This column's header cell.
   */
  @NotNull
  C getHeaderCell();

  /**
   * Sets the rounding that is used to format numbers in number-based formats.
   *
   * @param decimalPlaces number of decimal places, must be 0 or more.
   */
  void setRounding(int decimalPlaces);
}
