package com.almworks.jira.structure.api.generator.util;

import com.almworks.jira.structure.api.generator.*;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.collect.MapBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public abstract class AbstractGenerator implements ConfigurableGenerator {
  @Override
  public void addDefaultFormParameters(@NotNull Map<String, Object> form) throws GeneratorUnavailableException {}

  @Override
  public void addParametersToForm(@NotNull Map<String, Object> parameters, @NotNull Map<String, Object> form) throws GeneratorUnavailableException {}

  @NotNull
  @Override
  public Map<String, Object> buildParametersFromForm(@NotNull Map<String, Object> form, @NotNull ErrorCollection errors) throws GeneratorUnavailableException {
    return Collections.emptyMap();
  }

  @Override
  public void addParametersForSummary(@NotNull Map<String, Object> parameters, @NotNull Map<String, Object> summaryParameters) {
    // Note: parameters may contain driver parameters, but they shouldn't hurt since summaryParameters are only used in velocity
    // Also note: we need to HTML-encode all String parameters
    summaryParameters.putAll(parameters);
  }

  protected static Map<String, Object> mapOf(String key, Object value) {
    return MapBuilder.build(key, value);
  }

  protected static Map<String, Object> mapOf(String key1, Object value1, String key2, Object value2) {
    return MapBuilder.build(key1, value1, key2, value2);
  }

  @Nullable
  @Override
  public List<GeneratorPreset> getPresets() {
    return null;
  }

  @Override
  public boolean isAvailable() {
    return true;
  }

  public static abstract class Inserter extends AbstractGenerator implements ActionHandlingGenerator.Inserter {
    @Nullable
    @Override
    public ActionHandler.InserterActionHandler createActionHandler(@NotNull Map<String, Object> parameters) {
      return null;
    }
  }


  public static abstract class Extender extends AbstractGenerator implements ActionHandlingGenerator.Extender {
    @Nullable
    @Override
    public ActionHandler.ExtenderActionHandler createActionHandler(@NotNull Map<String, Object> parameters) {
      return null;
    }
  }


  public static abstract class Grouper extends AbstractGenerator implements ActionHandlingGenerator.Grouper {
    @Nullable
    @Override
    public ActionHandler.GrouperActionHandler createActionHandler(@NotNull Map<String, Object> parameters) {
      return null;
    }
  }


  public static abstract class Sorter extends AbstractGenerator implements ActionHandlingGenerator.Sorter {
    @Nullable
    @Override
    public ApplicabilityChecker getApplicabilityChecker(@NotNull Map<String, Object> parameters, @NotNull Context context) {
      return null;
    }

    @Nullable
    @Override
    public ActionHandler.SorterActionHandler createActionHandler(@NotNull Map<String, Object> parameters) {
      return null;
    }
  }


  public static abstract class Filter extends AbstractGenerator implements StructureGenerator.Filter {
  }
}
