package com.almworks.jira.structure.api.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.util.Arrays;

import static org.apache.commons.lang3.StringUtils.join;

/**
 * Representing i18n parameters: template key and arguments
 */
public class I18nText {
  private String myI18nKey; /** An i18n key */
  private Object[] myArguments; /** Message arguments: [String|Number|null] */

  @JsonCreator
  public I18nText(@JsonProperty("i18nKey") String i18nKey, @JsonProperty("arguments") Object... arguments) {
    myI18nKey = i18nKey;
    myArguments = Arrays.stream(arguments).map(arg ->
      arg == null || arg instanceof Number ? arg : arg.toString()
    ).toArray(Object[]::new);
  }

  public I18nText() {}

  public String getI18nKey() {
    return myI18nKey;
  }

  public void setI18nKey(String i18nKey) {
    myI18nKey = i18nKey;
  }

  public Object[] getArguments() {
    return myArguments;
  }

  public void setArguments(Object[] arguments) {
    myArguments = arguments;
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) { return false; }
    if (obj == this) { return true; }
    if (obj.getClass() != getClass()) {
      return false;
    }
    I18nText rhs = (I18nText) obj;
    return new EqualsBuilder()
      .append(this.myI18nKey, rhs.myI18nKey)
      .append(this.myArguments, rhs.myArguments)
      .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder()
      .append(myI18nKey)
      .append(myArguments)
      .toHashCode();
  }

  @Override
  public String toString() {
    return ArrayUtils.isEmpty(myArguments) ? myI18nKey : myI18nKey + join(myArguments, ",");
  }
}
