/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.attribute.loader.composition;

import com.almworks.integers.LongIterable;
import com.almworks.integers.LongSet;
import com.almworks.jira.structure.api.attribute.AttributeValue;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AggregateAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.attribute.loader.AttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.DerivedAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ItemAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.PropagateAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.RowAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.RowAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.ScanningAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeContext;
import com.almworks.jira.structure.api.attribute.loader.SingleRowAttributeLoader;
import com.almworks.jira.structure.api.attribute.loader.composition.LoaderType;
import com.almworks.jira.structure.api.attribute.loader.delegate.DelegatingAttributeLoader;
import com.almworks.jira.structure.api.forest.item.ItemForest;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.ItemAccessMode;
import com.almworks.jira.structure.api.row.StructureRow;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttributeLoaderAdapter<T, L extends AttributeLoader<T>>
extends DelegatingAttributeLoader<T, L> {
    private AttributeLoaderAdapter(@NotNull L loader) {
        super(loader);
    }

    static <T> Function<AttributeLoader<T>, AttributeLoader<T>> tryAdaptLoader(LoaderType targetLoaderType) {
        switch (targetLoaderType) {
            case ITEM: {
                return loader -> {
                    switch (LoaderType.getType(loader)) {
                        case DERIVED: {
                            return new DerivedToItem((DerivedAttributeLoader)loader);
                        }
                    }
                    return loader;
                };
            }
            case SINGLE_ROW: {
                return loader -> {
                    switch (LoaderType.getType(loader)) {
                        case DERIVED: {
                            return new DerivedToSingleRow((DerivedAttributeLoader)loader);
                        }
                        case ITEM: {
                            return new ItemToSingleRow((ItemAttributeLoader)loader);
                        }
                    }
                    return loader;
                };
            }
            case AGGREGATE: {
                return loader -> {
                    switch (LoaderType.getType(loader)) {
                        case DERIVED: {
                            return new DerivedToAggregate((DerivedAttributeLoader)loader);
                        }
                        case ITEM: {
                            return new ItemToAggregate((ItemAttributeLoader)loader);
                        }
                        case SINGLE_ROW: {
                            return new SingleRowToAggregate((SingleRowAttributeLoader)loader);
                        }
                    }
                    return loader;
                };
            }
            case PROPAGATE: {
                return loader -> {
                    switch (LoaderType.getType(loader)) {
                        case DERIVED: {
                            return new DerivedToPropagate((DerivedAttributeLoader)loader);
                        }
                        case ITEM: {
                            return new ItemToPropagate((ItemAttributeLoader)loader);
                        }
                        case SINGLE_ROW: {
                            return new SingleRowToPropagate((SingleRowAttributeLoader)loader);
                        }
                    }
                    return loader;
                };
            }
            case SCANNING: {
                return loader -> {
                    switch (LoaderType.getType(loader)) {
                        case DERIVED: {
                            return new DerivedToScanning((DerivedAttributeLoader)loader);
                        }
                        case ITEM: {
                            return new ItemToScanning((ItemAttributeLoader)loader);
                        }
                        case SINGLE_ROW: {
                            return new SingleRowToScanning((SingleRowAttributeLoader)loader);
                        }
                    }
                    return loader;
                };
            }
        }
        return loader -> loader;
    }

    public static <T, C extends AttributeLoader<T>> C adapt(@NotNull AttributeLoader<T> loader, @NotNull Class<C> clazz) {
        LoaderType wantedType;
        LoaderType currentType = LoaderType.getType(loader);
        if (currentType == (wantedType = LoaderType.getType(clazz))) {
            return (C)((AttributeLoader)clazz.cast(loader));
        }
        Function<AttributeLoader<AttributeLoader<T>>, AttributeLoader<AttributeLoader<T>>> f = AttributeLoaderAdapter.tryAdaptLoader(wantedType);
        AttributeLoader<T> adapted = f.apply(loader);
        if (adapted == loader) {
            throw new IllegalArgumentException("unadaptable loaders");
        }
        return (C)((AttributeLoader)clazz.cast(adapted));
    }

    L getAdaptedLoader() {
        return this.delegate();
    }

    /* synthetic */ AttributeLoaderAdapter(AttributeLoader x0, 1 x1) {
        this(x0);
    }

    private static class SingleRowToScanning<T>
    extends RowToRow<T, SingleRowAttributeLoader<T>>
    implements ScanningAttributeLoader<T> {
        SingleRowToScanning(SingleRowAttributeLoader<T> loader) {
            super(loader);
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull AttributeValue<T> precedingValue, @NotNull ScanningAttributeContext context) {
            assert (context instanceof SingleRowAttributeContext) : context;
            SingleRowAttributeContext singleRowContext = (SingleRowAttributeContext)((Object)context);
            return ((SingleRowAttributeLoader)this.delegate()).loadValue(singleRowContext.getRow(), singleRowContext);
        }
    }

    private static class SingleRowToPropagate<T>
    extends AttributeLoaderAdapter<T, SingleRowAttributeLoader<T>>
    implements PropagateAttributeLoader<T> {
        SingleRowToPropagate(SingleRowAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        @Nullable
        public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(@NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent context) {
            return (row, rowContext) -> {
                assert (rowContext instanceof SingleRowAttributeContext) : rowContext;
                SingleRowAttributeContext singleRowContext = (SingleRowAttributeContext)((Object)rowContext);
                return ((SingleRowAttributeLoader)this.delegate()).loadValue((StructureRow)row, singleRowContext);
            };
        }
    }

    private static class SingleRowToAggregate<T>
    extends RowToRow<T, SingleRowAttributeLoader<T>>
    implements AggregateAttributeLoader<T> {
        SingleRowToAggregate(SingleRowAttributeLoader<T> loader) {
            super(loader);
        }

        @Override
        public AttributeValue<T> loadValue(@NotNull List<AttributeValue<T>> childrenValues, @NotNull AggregateAttributeContext context) {
            assert (context instanceof SingleRowAttributeContext) : context;
            SingleRowAttributeContext singleRowContext = (SingleRowAttributeContext)((Object)context);
            return ((SingleRowAttributeLoader)this.delegate()).loadValue(singleRowContext.getRow(), singleRowContext);
        }
    }

    private static abstract class RowToRow<T, L extends RowAttributeLoader<T>>
    extends AttributeLoaderAdapter<T, L>
    implements RowAttributeLoader<T> {
        RowToRow(@NotNull L loader) {
            super((AttributeLoader)loader, null);
        }

        @Override
        public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
            ((RowAttributeLoader)this.delegate()).preload(rowIds, forest, context);
        }

        @Override
        public boolean isWholeForestDependent() {
            return ((RowAttributeLoader)this.delegate()).isWholeForestDependent();
        }
    }

    private static class ItemToScanning<T>
    extends ItemToRow<T>
    implements ScanningAttributeLoader<T> {
        ItemToScanning(ItemAttributeLoader<T> loader) {
            super(loader);
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull AttributeValue<T> precedingValue, @NotNull ScanningAttributeContext context) {
            return this.loadItemValue(context);
        }
    }

    private static class ItemToSingleRow<T>
    extends ItemToRow<T>
    implements SingleRowAttributeLoader<T> {
        ItemToSingleRow(ItemAttributeLoader<T> loader) {
            super(loader);
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull StructureRow row, @NotNull SingleRowAttributeContext context) {
            return this.loadItemValue(context);
        }
    }

    private static class ItemToPropagate<T>
    extends ItemToRow<T>
    implements PropagateAttributeLoader<T> {
        ItemToPropagate(ItemAttributeLoader<T> loader) {
            super(loader);
        }

        @Override
        @Nullable
        public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(@NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent context) {
            return (row, rowContext) -> this.loadItemValue((RowAttributeContext)rowContext);
        }
    }

    private static class ItemToAggregate<T>
    extends ItemToRow<T>
    implements AggregateAttributeLoader<T> {
        ItemToAggregate(ItemAttributeLoader<T> loader) {
            super(loader);
        }

        @Override
        public AttributeValue<T> loadValue(@NotNull List<AttributeValue<T>> childrenValues, @NotNull AggregateAttributeContext context) {
            return this.loadItemValue(context);
        }
    }

    private static abstract class ItemToRow<T>
    extends AttributeLoaderAdapter<T, ItemAttributeLoader<T>>
    implements RowAttributeLoader<T> {
        ItemToRow(ItemAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        public void preload(@NotNull LongSet rowIds, @NotNull ItemForest forest, @NotNull AttributeContext context) {
            HashSet<ItemIdentity> idSet = new HashSet<ItemIdentity>();
            forest.scanAllExistingRows((LongIterable)rowIds, false, ItemAccessMode.ITEM_NOT_NEEDED, row -> {
                ItemIdentity itemId = row.getItemId();
                if (((ItemAttributeLoader)this.delegate()).isItemTypeSupported(itemId.getItemType())) {
                    idSet.add(itemId);
                }
            });
            ((ItemAttributeLoader)this.delegate()).preload(idSet, context);
        }

        protected AttributeValue<T> loadItemValue(RowAttributeContext context) {
            assert (context instanceof ItemAttributeContext) : context;
            ItemAttributeContext itemContext = (ItemAttributeContext)((Object)context);
            ItemIdentity itemId = itemContext.getItemId();
            if (((ItemAttributeLoader)this.delegate()).isItemTypeSupported(itemId.getItemType())) {
                return ((ItemAttributeLoader)this.delegate()).loadValue(itemId, itemContext);
            }
            return null;
        }
    }

    private static class DerivedToScanning<T>
    extends AttributeLoaderAdapter<T, DerivedAttributeLoader<T>>
    implements ScanningAttributeLoader<T> {
        DerivedToScanning(DerivedAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull AttributeValue<T> precedingValue, @NotNull ScanningAttributeContext context) {
            assert (context instanceof DerivedAttributeContext) : context;
            DerivedAttributeContext derivedContext = (DerivedAttributeContext)((Object)context);
            return ((DerivedAttributeLoader)this.delegate()).loadValue(derivedContext);
        }
    }

    private static class DerivedToSingleRow<T>
    extends AttributeLoaderAdapter<T, DerivedAttributeLoader<T>>
    implements SingleRowAttributeLoader<T> {
        DerivedToSingleRow(DerivedAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull StructureRow row, @NotNull SingleRowAttributeContext context) {
            assert (context instanceof DerivedAttributeContext) : context;
            DerivedAttributeContext derivedContext = (DerivedAttributeContext)((Object)context);
            return ((DerivedAttributeLoader)this.delegate()).loadValue(derivedContext);
        }
    }

    private static class DerivedToPropagate<T>
    extends AttributeLoaderAdapter<T, DerivedAttributeLoader<T>>
    implements PropagateAttributeLoader<T> {
        DerivedToPropagate(DerivedAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        @Nullable
        public BiFunction<StructureRow, PropagateAttributeContext, AttributeValue<T>> loadChildren(@NotNull AttributeValue<T> parentValue, @NotNull PropagateAttributeContext.Parent context) {
            return this::loadChild;
        }

        private AttributeValue<T> loadChild(StructureRow row, PropagateAttributeContext rowContext) {
            assert (rowContext instanceof DerivedAttributeContext) : rowContext;
            DerivedAttributeContext derivedContext = (DerivedAttributeContext)((Object)rowContext);
            return ((DerivedAttributeLoader)this.delegate()).loadValue(derivedContext);
        }
    }

    private static class DerivedToItem<T>
    extends AttributeLoaderAdapter<T, DerivedAttributeLoader<T>>
    implements ItemAttributeLoader<T> {
        DerivedToItem(DerivedAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        public boolean isItemTypeSupported(@NotNull String itemType) {
            return true;
        }

        @Override
        @Nullable
        public AttributeValue<T> loadValue(@NotNull ItemIdentity itemId, @NotNull ItemAttributeContext context) {
            assert (context instanceof DerivedAttributeContext) : context;
            DerivedAttributeContext derivedContext = (DerivedAttributeContext)((Object)context);
            return ((DerivedAttributeLoader)this.delegate()).loadValue(derivedContext);
        }
    }

    private static class DerivedToAggregate<T>
    extends AttributeLoaderAdapter<T, DerivedAttributeLoader<T>>
    implements AggregateAttributeLoader<T> {
        DerivedToAggregate(DerivedAttributeLoader<T> loader) {
            super(loader, null);
        }

        @Override
        public AttributeValue<T> loadValue(@NotNull List<AttributeValue<T>> childrenValues, @NotNull AggregateAttributeContext context) {
            assert (context instanceof DerivedAttributeContext) : context;
            DerivedAttributeContext derivedContext = (DerivedAttributeContext)((Object)context);
            return ((DerivedAttributeLoader)this.delegate()).loadValue(derivedContext);
        }
    }
}

