/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.row;

import com.almworks.integers.LongCollector;
import com.almworks.integers.LongIterable;
import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.item.CoreIdentities;
import com.almworks.jira.structure.api.item.ItemIdentity;
import com.almworks.jira.structure.api.row.ItemAccessMode;
import com.almworks.jira.structure.api.row.MissingRowException;
import com.almworks.jira.structure.api.row.StructureRow;
import com.almworks.jira.structure.api.util.Ref;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface RowRetriever {
    public static final LongCollector IGNORE_MISSING_ROWS = LongCollector.DUMMY;

    @NotNull
    default public StructureRow getRow(long rowId) throws MissingRowException {
        return this.getRow(rowId, ItemAccessMode.NORMAL_ACCESS);
    }

    @NotNull
    public StructureRow getRow(long var1, @NotNull ItemAccessMode var3) throws MissingRowException;

    default public void scanRows(@Nullable LongIterable rows, boolean sorted, @NotNull ItemAccessMode access, @Nullable LongCollector missingCollector, @NotNull Predicate<StructureRow> iteratee) throws MissingRowException {
        if (rows != null) {
            for (LongIterator ii : rows) {
                try {
                    StructureRow row = this.getRow(ii.value(), access);
                    if (iteratee.test(row)) continue;
                    break;
                }
                catch (MissingRowException e) {
                    if (missingCollector == null) {
                        throw e;
                    }
                    missingCollector.add(ii.value());
                }
            }
        }
    }

    default public void scanRows(@Nullable LongIterable rows, boolean sorted, @Nullable LongCollector missingCollector, @NotNull Predicate<StructureRow> iteratee) throws MissingRowException {
        this.scanRows(rows, sorted, ItemAccessMode.NORMAL_ACCESS, missingCollector, iteratee);
    }

    default public void scanRows(@Nullable LongIterable rows, @Nullable LongCollector missingCollector, @NotNull Predicate<StructureRow> iteratee) throws MissingRowException {
        this.scanRows(rows, false, ItemAccessMode.NORMAL_ACCESS, missingCollector, iteratee);
    }

    default public void scanRows(@Nullable LongIterable rows, @NotNull Predicate<StructureRow> iteratee) throws MissingRowException {
        this.scanRows(rows, false, ItemAccessMode.NORMAL_ACCESS, null, iteratee);
    }

    default public void scanAllRows(@Nullable LongIterable rows, boolean sorted, @NotNull ItemAccessMode access, @Nullable LongCollector missingCollector, @NotNull Consumer<StructureRow> consumer) throws MissingRowException {
        this.scanRows(rows, sorted, access, missingCollector, row -> {
            consumer.accept((StructureRow)row);
            return true;
        });
    }

    default public void scanAllRows(@Nullable LongIterable rows, boolean sorted, @Nullable LongCollector missingCollector, @NotNull Consumer<StructureRow> consumer) throws MissingRowException {
        this.scanAllRows(rows, sorted, ItemAccessMode.NORMAL_ACCESS, missingCollector, consumer);
    }

    default public void scanAllRows(@Nullable LongIterable rows, @Nullable LongCollector missingCollector, @NotNull Consumer<StructureRow> consumer) throws MissingRowException {
        this.scanAllRows(rows, false, missingCollector, consumer);
    }

    default public void scanAllRows(@Nullable LongIterable rows, @NotNull Consumer<StructureRow> consumer) throws MissingRowException {
        this.scanAllRows(rows, null, consumer);
    }

    default public void scanAllExistingRows(@Nullable LongIterable rows, boolean sorted, @NotNull ItemAccessMode access, @NotNull Consumer<StructureRow> consumer) {
        this.scanAllRows(rows, sorted, access, IGNORE_MISSING_ROWS, consumer);
    }

    default public void scanAllExistingRows(@Nullable LongIterable rows, boolean sorted, @NotNull Consumer<StructureRow> consumer) {
        this.scanAllExistingRows(rows, sorted, ItemAccessMode.NORMAL_ACCESS, consumer);
    }

    default public void scanAllExistingRows(@Nullable LongIterable rows, @NotNull Consumer<StructureRow> consumer) {
        this.scanAllExistingRows(rows, false, consumer);
    }

    @Nullable
    default public <T> T reduceOverRows(@Nullable LongIterable rows, @Nullable T startingValue, @NotNull BiFunction<StructureRow, T, T> accumulator) throws MissingRowException {
        if (rows == null) {
            return startingValue;
        }
        Ref<T> r = new Ref<T>(startingValue);
        this.scanRows(rows, false, ItemAccessMode.NORMAL_ACCESS, null, row -> {
            r.value = accumulator.apply((StructureRow)row, r.value);
            return true;
        });
        return r.value;
    }

    @NotNull
    default public <C extends LongCollector> C collectIssueIds(@Nullable LongIterable rows, boolean sorted, @NotNull C issuesCollector) {
        if (rows == null) {
            return issuesCollector;
        }
        this.scanRows(rows, sorted, ItemAccessMode.ITEM_NOT_NEEDED, IGNORE_MISSING_ROWS, row -> {
            ItemIdentity itemId = row.getItemId();
            if (CoreIdentities.isIssue(itemId)) {
                issuesCollector.add(itemId.getLongId());
            }
            return true;
        });
        return issuesCollector;
    }

    @NotNull
    default public <C extends LongCollector> C collectIssueIds(@Nullable LongIterable rows, @NotNull C issuesCollector) {
        return this.collectIssueIds(rows, false, issuesCollector);
    }

    @NotNull
    public Set<ItemIdentity> collectItemIds(@Nullable LongIterable var1);
}

