/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.integers.LongArray;
import com.almworks.integers.LongFindingIterator;
import com.almworks.integers.LongIterator;
import com.almworks.jira.structure.api.util.La;
import com.atlassian.jira.util.lang.Pair;
import java.util.ConcurrentModificationException;
import java.util.function.LongPredicate;
import org.jetbrains.annotations.NotNull;

public class LongFilteringIterator
extends LongFindingIterator {
    private final LongIterator mySource;
    private final LongPredicate myFilter;

    public LongFilteringIterator(LongIterator source, La<Long, ?> filter) {
        this.mySource = source;
        this.myFilter = filter::accepts;
    }

    public LongFilteringIterator(@NotNull LongIterator source, @NotNull LongPredicate filter) {
        this.mySource = source;
        this.myFilter = filter;
    }

    protected boolean findNext() throws ConcurrentModificationException {
        while (this.mySource.hasNext()) {
            long v = this.mySource.nextValue();
            if (!this.myFilter.test(v)) continue;
            this.myNext = v;
            return true;
        }
        return false;
    }

    public static Pair<LongIterator, LongIterator> split(LongIterator iterator, La<Long, ?> filter) {
        LongArray array = new LongArray(iterator);
        return Pair.of((Object)((Object)new LongFilteringIterator((LongIterator)array.iterator(), filter)), (Object)((Object)new LongFilteringIterator((LongIterator)array.iterator(), filter.not())));
    }
}

