package com.almworks.jira.structure.api.export.excel;

import com.almworks.jira.structure.api.attribute.loader.AttributeContext;
import com.almworks.jira.structure.api.export.ExportColumn;
import com.almworks.jira.structure.api.export.ExportContextKeys;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * <p>{@code ExcelColumn} is a specialization of {@link ExportColumn} for exporting to the Microsoft Excel format,
 * offering limited support for Excel-specific styling.</p>
 *
 * <p>Excel export is backed by Apache POI. For advanced formatting you can call the underlying POI objects directly,
 * obtaining them from the column context.</p>
 *
 * @see ExcelCell
 * @see AttributeContext#getObject(Object)
 * @see ExportContextKeys.Excel
 */
@PublicApi
public interface ExcelColumn extends ExportColumn<ExcelCell> {
  /**
   * Set the default cell style. The default style is applied to all of the cells in this column that don't have their
   * style set by calling {@link ExcelCell#setStyle(ExcelStyle)}. We recommend that you set the single (or the most
   * frequently used) style as the default column style, instead of applying this style to each cell.
   *
   * @param style The style.
   */
  void setDefaultStyle(@Nullable ExcelStyle style);
}
